/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIContentNameSearch
extends UIForm {
    private static String KEYWORD = "keyword";
    private static String SEARCH_LOCATION = "location";
    private static final String ROOT_PATH_SQL_QUERY = "select * from nt:base where contains(exo:name, '$1') or contains(exo:title, '$1') or  lower(exo:name) like '%$2%' order by exo:title ASC";
    private static final String PATH_SQL_QUERY = "select * from nt:base where jcr:path like '$0/%' AND ( contains(exo:name, '$1') or contains(exo:title, '$1') or lower(exo:name) like '%$2%') order by exo:title ASC";

    public UIContentNameSearch() throws Exception {
        this.addChild((UIComponent)new UIFormInputInfo(SEARCH_LOCATION, null, null));
        this.addChild((UIComponent)new UIFormStringInput(KEYWORD, null).addValidator(MandatoryValidator.class, new Object[0]));
    }

    public void setLocation(String location) {
        this.getUIFormInputInfo(SEARCH_LOCATION).setValue((Object)location);
    }

    public static class CancelActionListener
    extends EventListener<UIContentNameSearch> {
        public void execute(Event<UIContentNameSearch> event) throws Exception {
            ((UIJCRExplorer)((UIContentNameSearch)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class)).cancelAction();
        }
    }

    public static class SearchActionListener
    extends EventListener<UIContentNameSearch> {
        public void execute(Event<UIContentNameSearch> event) throws Exception {
            UIContentNameSearch contentNameSearch = (UIContentNameSearch)((Object)event.getSource());
            UIECMSearch uiECMSearch = (UIECMSearch)contentNameSearch.getAncestorOfType(UIECMSearch.class);
            UISearchResult uiSearchResult = (UISearchResult)uiECMSearch.getChild(UISearchResult.class);
            UIApplication application = (UIApplication)contentNameSearch.getAncestorOfType(UIApplication.class);
            try {
                String keyword = (String)contentNameSearch.getUIStringInput(KEYWORD).getValue();
                keyword = keyword.trim();
                String escapedText = Utils.escapeIllegalCharacterInQuery((String)keyword);
                UIJCRExplorer explorer = (UIJCRExplorer)contentNameSearch.getAncestorOfType(UIJCRExplorer.class);
                String currentNodePath = explorer.getCurrentNode().getPath();
                String statement = null;
                if ("/".equalsIgnoreCase(currentNodePath)) {
                    statement = StringUtils.replace((String)UIContentNameSearch.ROOT_PATH_SQL_QUERY, (String)"$1", (String)escapedText);
                    statement = StringUtils.replace((String)statement, (String)"$2", (String)escapedText.toLowerCase());
                } else {
                    statement = StringUtils.replace((String)UIContentNameSearch.PATH_SQL_QUERY, (String)"$0", (String)currentNodePath);
                    statement = StringUtils.replace((String)statement, (String)"$1", (String)escapedText);
                    statement = StringUtils.replace((String)statement, (String)"$2", (String)escapedText.toLowerCase());
                }
                long startTime = System.currentTimeMillis();
                uiSearchResult.setQuery(statement, explorer.getTargetSession().getWorkspace().getName(), "sql", IdentityConstants.SYSTEM.equals(explorer.getTargetSession()), null);
                uiSearchResult.updateGrid();
                long time = System.currentTimeMillis() - startTime;
                uiSearchResult.setSearchTime(time);
                contentNameSearch.getUIFormInputInfo(SEARCH_LOCATION).setValue((Object)currentNodePath);
                uiECMSearch.setSelectedTab(uiSearchResult.getId());
            }
            catch (RepositoryException reEx) {
                application.addMessage(new ApplicationMessage("UIContentNameSearch.msg.keyword-not-allowed", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentNameSearch);
                return;
            }
            catch (Exception e) {
                uiSearchResult.setQuery(null, null, null, false, null);
                uiSearchResult.updateGrid();
            }
        }
    }
}

