/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerContainer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UIAllItems;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UIAllItemsByType;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UIClipboard;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISavedSearches;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITagExplorer;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UIViewRelationList;
import org.exoplatform.ecm.webui.component.explorer.sidebar.action.ExplorerActionComponent;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(template="app:/groovy/webui/component/explorer/sidebar/UISideBar.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, csrfCheck=false)})
public class UISideBar
extends UIContainer {
    public static final String UI_TAG_EXPLORER = "TagExplorer";
    private String currentComp;
    private static final Log LOG = ExoLogger.getLogger((String)UISideBar.class.getName());
    public static final String EXTENSION_TYPE = "org.exoplatform.ecm.dms.UISideBar";
    public static final int VISIBLE_COMPONENT_SIZE = 5;
    private List<UIAbstractManagerComponent> managers = Collections.synchronizedList(new ArrayList());
    private String selectedComp;
    private List<UIAbstractManagerComponent> lstVisibleComp;
    private List<UIAbstractManagerComponent> lstHiddenComp;

    public UISideBar() throws Exception {
        ((UITreeExplorer)this.addChild(UITreeExplorer.class, null, null)).setRendered(false);
        ((UIViewRelationList)this.addChild(UIViewRelationList.class, null, null)).setRendered(false);
        ((UITagExplorer)this.addChild(UITagExplorer.class, null, null)).setRendered(false);
        ((UIClipboard)this.addChild(UIClipboard.class, null, null)).setRendered(false);
        ((UISavedSearches)this.addChild(UISavedSearches.class, null, null)).setRendered(false);
        this.addChild(UIAllItems.class, null, null);
        this.addChild(UIAllItemsByType.class, null, null);
    }

    public List<UIAbstractManagerComponent> getLstVisibleComp() {
        return this.lstVisibleComp;
    }

    public void setLstVisibleComp(List<UIAbstractManagerComponent> lstVisibleComp) {
        this.lstVisibleComp = lstVisibleComp;
    }

    public List<UIAbstractManagerComponent> getLstHiddenComp() {
        return this.lstHiddenComp;
    }

    public void setLstHiddenComp(List<UIAbstractManagerComponent> lstHiddenComp) {
        this.lstHiddenComp = lstHiddenComp;
    }

    public void setSelectedComp(String componentName) {
        this.selectedComp = componentName;
    }

    public void initComponents() throws Exception {
        this.lstVisibleComp = new ArrayList<UIAbstractManagerComponent>(5);
        this.lstHiddenComp = new ArrayList<UIAbstractManagerComponent>();
        List<UIAbstractManagerComponent> managers = this.getManagers();
        for (int i = 0; i < managers.size(); ++i) {
            UIAbstractManagerComponent component = managers.get(i);
            if (this.lstVisibleComp.size() < 5) {
                if (this.isHideExplorerPanel() && component instanceof ExplorerActionComponent) continue;
                this.lstVisibleComp.add(component);
                continue;
            }
            this.lstHiddenComp.add(component);
        }
    }

    public String getCurrentComp() throws Exception {
        if (this.currentComp == null || this.currentComp.length() == 0) {
            this.currentComp = ((UITreeExplorer)this.getChild(UITreeExplorer.class)).getId();
        }
        if (this.isHideExplorerPanel() && ((UITreeExplorer)this.getChild(UITreeExplorer.class)).getId().equals(this.currentComp)) {
            this.currentComp = ((UITagExplorer)this.getChild(UITagExplorer.class)).getId();
            ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).setCurrentState();
            ((UITagExplorer)this.getChild(UITagExplorer.class)).updateTagList();
        }
        return this.currentComp;
    }

    public String getSelectedComp() throws Exception {
        if (this.selectedComp == null || this.selectedComp.length() == 0) {
            this.selectedComp = "Explorer";
        }
        if (this.isHideExplorerPanel() && "Explorer".equals(this.selectedComp)) {
            this.selectedComp = UI_TAG_EXPLORER;
        }
        return this.selectedComp;
    }

    public void updateSideBarView() throws Exception {
        boolean showFilterBar = ((UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class)).isShowFilterBar();
        ((UIAllItems)this.getChild(UIAllItems.class)).setRendered(showFilterBar);
        ((UIAllItemsByType)this.getChild(UIAllItemsByType.class)).setRendered(showFilterBar);
    }

    public void setCurrentComp(String currentComp) {
        this.currentComp = currentComp;
    }

    public void renderSideBarChild(String[] arrId) throws Exception {
        for (String id : arrId) {
            this.setRenderedChild(id);
            this.renderChild(id);
        }
    }

    public String getRepository() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    private List<UIExtension> getUIExtensionList() {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        return manager.getUIExtensions(EXTENSION_TYPE);
    }

    public synchronized void initialize() throws Exception {
        List<UIExtension> extensions = this.getUIExtensionList();
        if (extensions == null) {
            return;
        }
        this.managers.clear();
        HashMap<String, Object> context = new HashMap<String, Object>();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        context.put(UIJCRExplorer.class.getName(), (Object)uiExplorer);
        for (UIExtension extension : extensions) {
            UIComponent component = this.addUIExtension(extension, context);
            if (component == null || this.managers.contains(component)) continue;
            this.managers.add((UIAbstractManagerComponent)component);
        }
        this.initComponents();
    }

    private synchronized UIComponent addUIExtension(UIExtension extension, Map<String, Object> context) throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        UIComponent component = manager.addUIExtension(extension, context, (UIContainer)this);
        if (component instanceof UIAbstractManagerComponent) {
            UIAbstractManagerComponent uiAbstractManagerComponent = (UIAbstractManagerComponent)component;
            uiAbstractManagerComponent.setUIExtensionName(extension.getName());
            uiAbstractManagerComponent.setUIExtensionCategory(extension.getCategory());
            return component;
        }
        if (component != null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("All the extension '" + extension.getName() + "' of type 'org.exoplatform.ecm.dms.UISideBar' must be associated to a component of type " + UIAbstractManagerComponent.class));
            }
            this.removeChild(component.getClass());
        }
        return null;
    }

    public List<UIAbstractManagerComponent> getManagers() {
        ArrayList<UIAbstractManagerComponent> managers = new ArrayList<UIAbstractManagerComponent>();
        managers.addAll(this.managers);
        return managers;
    }

    public void unregister(UIAbstractManagerComponent component) {
        this.managers.remove(component);
    }

    public boolean isRenderComponent(String actionName) throws Exception {
        if ("Explorer".equals(actionName)) {
            return !this.isHideExplorerPanel();
        }
        return true;
    }

    private boolean isHideExplorerPanel() throws Exception {
        UIAddressBar uiAddress = (UIAddressBar)((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).findFirstComponentOfType(UIAddressBar.class);
        String viewName = uiAddress.getSelectedViewName();
        Node viewNode = ((ManageViewService)WCMCoreUtils.getService(ManageViewService.class)).getViewByName(viewName, WCMCoreUtils.getSystemSessionProvider());
        return viewNode.getProperty("exo:hideExplorerPanel").getBoolean();
    }

    public static class CloseActionListener
    extends EventListener<UISideBar> {
        public void execute(Event<UISideBar> event) throws Exception {
            UIWorkingArea uiWorkingArea = (UIWorkingArea)((UISideBar)((Object)event.getSource())).getParent();
            uiWorkingArea.setShowSideBar(false);
            UIJCRExplorerPortlet explorerPorltet = (UIJCRExplorerPortlet)uiWorkingArea.getAncestorOfType(UIJCRExplorerPortlet.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)explorerPorltet.findFirstComponentOfType(UIJCRExplorer.class);
            UIJcrExplorerContainer uiJcrExplorerContainer = (UIJcrExplorerContainer)explorerPorltet.getChild(UIJcrExplorerContainer.class);
            uiExplorer.refreshExplorer();
            uiJcrExplorerContainer.setRenderedChild(UIJCRExplorer.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiExplorer);
        }
    }
}

