/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.symlink;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.symlink.UIAddTranslationManager;
import org.exoplatform.ecm.webui.component.explorer.symlink.UITranslationFormMultiValueInputSet;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.exceptions.SameAsDefaultLangException;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.selector.content.one.UIContentBrowsePanelOne;
import org.exoplatform.wcm.webui.selector.content.one.UIContentSelectorOne;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/thumbnail/UIAddTranslationForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UITranslationFormMultiValueInputSet.class, id="SymLinkMultipleInputset", events={@EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectDocumentActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIAddTranslationForm
extends UIForm
implements UIPopupComponent,
UISelectable {
    public static final String FIELD_PATH = "pathNode";
    public static final String FIELD_SYMLINK = "fieldPathNode";
    public static final String POPUP_SYMLINK = "UIPopupSymLink";
    private static final Log LOG = ExoLogger.getLogger((String)UIAddTranslationForm.class.getName());
    public static final byte DRIVE_SELECTOR_MODE = 0;
    public static final byte WORSPACE_SELECTOR_MODE = 1;
    private byte selectorMode = 0;

    public void activate() {
    }

    public void deActivate() {
    }

    public void initFieldInput() throws Exception {
        UITranslationFormMultiValueInputSet uiTranslationFormMultiValue = (UITranslationFormMultiValueInputSet)this.createUIComponent(UITranslationFormMultiValueInputSet.class, "SymLinkMultipleInputset", null);
        uiTranslationFormMultiValue.setId(FIELD_PATH);
        uiTranslationFormMultiValue.setName(FIELD_PATH);
        uiTranslationFormMultiValue.setEditable(false);
        uiTranslationFormMultiValue.setType(UIFormStringInput.class);
        this.addUIFormInput((UIFormInput)uiTranslationFormMultiValue);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String valueNodeName = String.valueOf(value).trim();
        String workspaceName = valueNodeName.substring(0, valueNodeName.lastIndexOf(":/"));
        valueNodeName = valueNodeName.substring(workspaceName.lastIndexOf(":") + 1);
        ArrayList<String> listNodeName = new ArrayList<String>();
        listNodeName.add(valueNodeName);
        UITranslationFormMultiValueInputSet uiTranslationFormMultiValueInputSet = (UITranslationFormMultiValueInputSet)this.getChild(UITranslationFormMultiValueInputSet.class);
        uiTranslationFormMultiValueInputSet.setValue(listNodeName);
        String symLinkName = valueNodeName.substring(valueNodeName.lastIndexOf("/") + 1);
        int squareBracketIndex = symLinkName.indexOf(91);
        if (squareBracketIndex > -1) {
            symLinkName = symLinkName.substring(0, squareBracketIndex);
        }
        if (symLinkName.indexOf(".lnk") < 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(symLinkName).append(".lnk");
            symLinkName = sb.toString();
        }
        symLinkName = Text.unescapeIllegalJcrChars((String)symLinkName);
        UIAddTranslationManager uiAddTranslationManager = (UIAddTranslationManager)this.getParent();
        uiAddTranslationManager.removeChildById(POPUP_SYMLINK);
    }

    public void useWorkspaceSelector() {
        this.selectorMode = 1;
    }

    public void useDriveSelector() {
        this.selectorMode = 0;
    }

    public boolean isUseWorkspaceSelector() {
        return this.selectorMode == 1;
    }

    public static class SelectDocumentActionListener
    extends EventListener<UITranslationFormMultiValueInputSet> {
        private String fixPath(String path, String driveName, String repo, UIAddTranslationForm uiAddTranslationForm) throws Exception {
            if (path == null || path.length() == 0 || driveName == null || driveName.length() == 0 || repo == null || repo.length() == 0) {
                return "";
            }
            ManageDriveService managerDriveService = (ManageDriveService)uiAddTranslationForm.getApplicationComponent(ManageDriveService.class);
            DriveData driveData = managerDriveService.getDriveByName(driveName);
            if (!path.startsWith(driveData.getHomePath())) {
                return "";
            }
            if ("/".equals(driveData.getHomePath())) {
                return path;
            }
            return path.substring(driveData.getHomePath().length());
        }

        public void execute(Event<UITranslationFormMultiValueInputSet> event) throws Exception {
            UITranslationFormMultiValueInputSet uiSet = (UITranslationFormMultiValueInputSet)((Object)event.getSource());
            UIAddTranslationForm uiTranslationForm = (UIAddTranslationForm)uiSet.getParent();
            UIAddTranslationManager uiAddTranslationManager = (UIAddTranslationManager)uiTranslationForm.getParent();
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTranslationForm.getAncestorOfType(UIJCRExplorer.class);
            String workspaceName = uiExplorer.getCurrentWorkspace();
            String param = "returnField=fieldPathNode";
            UIPopupWindow uiPopupWindow = uiAddTranslationManager.initPopupTaxonomy(UIAddTranslationForm.POPUP_SYMLINK);
            if (uiTranslationForm.isUseWorkspaceSelector()) {
                UIOneNodePathSelector uiNodePathSelector = (UIOneNodePathSelector)uiAddTranslationManager.createUIComponent(UIOneNodePathSelector.class, null, null);
                uiPopupWindow.setUIComponent((UIComponent)uiNodePathSelector);
                uiNodePathSelector.setIsDisable(workspaceName, false);
                uiNodePathSelector.setExceptedNodeTypesInPathPanel(new String[]{"exo:symlink"});
                uiNodePathSelector.setRootNodeLocation(uiExplorer.getRepositoryName(), workspaceName, "/");
                uiNodePathSelector.setIsShowSystem(false);
                uiNodePathSelector.init(WCMCoreUtils.getUserSessionProvider());
                uiNodePathSelector.setSourceComponent((UIComponent)uiTranslationForm, new String[]{param});
            } else {
                Node node = uiExplorer.getCurrentNode();
                UIContentSelectorOne uiNodePathSelector = (UIContentSelectorOne)uiTranslationForm.createUIComponent(UIContentSelectorOne.class, null, null);
                uiPopupWindow.setUIComponent((UIComponent)uiNodePathSelector);
                uiNodePathSelector.init(uiExplorer.getDriveData().getName(), this.fixPath(node == null ? "" : node.getPath(), uiExplorer.getDriveData().getName(), uiExplorer.getRepositoryName(), uiTranslationForm));
                ((UIContentBrowsePanelOne)uiNodePathSelector.getChild(UIContentBrowsePanelOne.class)).setSourceComponent((UIComponent)uiTranslationForm, new String[]{param});
            }
            uiPopupWindow.setRendered(true);
            uiPopupWindow.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiAddTranslationManager);
        }
    }

    public static class RemoveActionListener
    extends EventListener<UITranslationFormMultiValueInputSet> {
        public void execute(Event<UITranslationFormMultiValueInputSet> event) throws Exception {
            UITranslationFormMultiValueInputSet uiSet = (UITranslationFormMultiValueInputSet)((Object)event.getSource());
            UIComponent uiComponent = uiSet.getParent();
            if (uiComponent instanceof UIAddTranslationForm) {
                UIAddTranslationForm uiTranslationForm = (UIAddTranslationForm)uiComponent;
                String id = event.getRequestContext().getRequestParameter("objectId");
                uiSet.removeChildById(id);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTranslationForm);
            }
        }
    }

    public static class CancelActionListener
    extends EventListener<UIAddTranslationForm> {
        public void execute(Event<UIAddTranslationForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIAddTranslationForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UIAddTranslationForm> {
        public void execute(Event<UIAddTranslationForm> event) throws Exception {
            UIAddTranslationForm uiTranslationForm = (UIAddTranslationForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTranslationForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiTranslationForm.getAncestorOfType(UIApplication.class);
            String pathNode = "";
            UITranslationFormMultiValueInputSet uiSet = (UITranslationFormMultiValueInputSet)uiTranslationForm.getChild(UITranslationFormMultiValueInputSet.class);
            List listChildren = uiSet.getChildren();
            for (UIComponent component : listChildren) {
                UIFormStringInput uiStringInput = (UIFormStringInput)component;
                if (uiStringInput.getValue() == null) continue;
                pathNode = ((String)uiStringInput.getValue()).trim();
            }
            Node node = uiExplorer.getCurrentNode();
            if (uiExplorer.nodeIsLocked(node)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", null));
                return;
            }
            if (pathNode == null || pathNode.length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.path-node-invalid", null));
                return;
            }
            String workspaceName = pathNode.substring(0, pathNode.lastIndexOf(":/"));
            pathNode = pathNode.substring(pathNode.lastIndexOf(":/") + 1);
            NodeFinder nodeFinder = (NodeFinder)uiTranslationForm.getApplicationComponent(NodeFinder.class);
            try {
                nodeFinder.getItem(workspaceName, pathNode);
            }
            catch (ItemNotFoundException e) {
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.non-node", null, 1));
                return;
            }
            catch (RepositoryException re) {
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.non-node", null, 1));
                return;
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"An unexpected error occurs", (Throwable)e);
                }
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.non-node", null, 1));
                return;
            }
            try {
                Node targetNode = (Node)nodeFinder.getItem(workspaceName, pathNode);
                MultiLanguageService langService = (MultiLanguageService)uiTranslationForm.getApplicationComponent(MultiLanguageService.class);
                langService.addSynchronizedLinkedLanguage(node, targetNode);
                uiExplorer.updateAjax(event);
            }
            catch (AccessControlException ace) {
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.repository-exception", null, 1));
                return;
            }
            catch (AccessDeniedException ade) {
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.repository-exception", null, 1));
                return;
            }
            catch (NumberFormatException nume) {
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.numberformat-exception", null, 1));
                return;
            }
            catch (ConstraintViolationException cve) {
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.cannot-save", null, 1));
                return;
            }
            catch (ItemExistsException iee) {
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.item-exists-exception", null, 1));
                return;
            }
            catch (UnsupportedRepositoryOperationException unOperationException) {
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.UnsupportedRepositoryOperationException", null, 1));
                return;
            }
            catch (SameAsDefaultLangException unOperationException) {
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.translation-node-same-language-default", null, 1));
                return;
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error", (Throwable)e);
                }
                uiApp.addMessage(new ApplicationMessage("UIAddTranslationForm.msg.cannot-save", null, 1));
                return;
            }
        }
    }
}

