/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.seo;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.seo.PageMetadataModel;
import org.exoplatform.services.seo.SEOService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.reader.ContentReader;
import org.exoplatform.wcm.webui.seo.UISEOForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/webui/seo/UISEOPortletToolbar.gtmpl", events={@EventConfig(listeners={AddSEOActionListener.class})})
public class UISEOToolbarForm
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger((String)UISEOToolbarForm.class.getName());
    public static final String SEO_POPUP_WINDOW = "UISEOPopupWindow";
    private ArrayList<String> paramsArray = null;
    private String pageReference = null;
    private PageMetadataModel metaModel = null;
    private String fullStatus = "Empty";
    private String lang = null;

    public ArrayList<String> getParamsArray() {
        return this.paramsArray;
    }

    public String getPageReference() {
        return this.pageReference;
    }

    public PageMetadataModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(PageMetadataModel metaModel) {
        this.metaModel = metaModel;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        StringBuffer sb = new StringBuffer();
        sb.append(pcontext.getLocale().getLanguage());
        if (StringUtils.isNotEmpty((String)pcontext.getLocale().getCountry())) {
            sb.append("_").append(pcontext.getLocale().getCountry());
        }
        this.lang = sb.toString();
        String portalName = pcontext.getPortalOwner();
        this.metaModel = null;
        this.fullStatus = "Empty";
        if (!pcontext.useAjax()) {
            this.paramsArray = null;
            Enumeration params = pcontext.getRequest().getParameterNames();
            if (params.hasMoreElements()) {
                this.paramsArray = new ArrayList();
                while (params.hasMoreElements()) {
                    String contentValue;
                    String contentParam = params.nextElement().toString();
                    try {
                        contentValue = Text.unescape((String)pcontext.getRequestParameter(contentParam));
                    }
                    catch (Exception ex) {
                        contentValue = pcontext.getRequestParameter(contentParam);
                    }
                    contentValue = ContentReader.getXSSCompatibilityContent((String)contentValue);
                    if (this.paramsArray == null) continue;
                    this.paramsArray.add(Text.escapeIllegalJcrChars((String)contentValue));
                }
            }
        }
        SEOService seoService = (SEOService)WCMCoreUtils.getService(SEOService.class);
        this.pageReference = Util.getUIPortal().getSelectedUserNode().getPageRef().format();
        if (this.pageReference != null) {
            SiteKey siteKey = Util.getUIPortal().getSelectedUserNode().getNavigation().getKey();
            SiteKey portalKey = SiteKey.portal((String)portalName);
            if (siteKey != null && siteKey.equals((Object)portalKey)) {
                this.metaModel = seoService.getPageMetadata(this.pageReference, this.lang);
                if (this.paramsArray != null) {
                    PageMetadataModel tmpModel;
                    block18: {
                        tmpModel = null;
                        try {
                            tmpModel = seoService.getContentMetadata(this.paramsArray, this.lang);
                        }
                        catch (PathNotFoundException ex) {
                            if (!LOG.isErrorEnabled()) break block18;
                            LOG.error((Object)"Cannot found the content metadata", (Throwable)ex);
                        }
                    }
                    if (tmpModel != null) {
                        this.metaModel = tmpModel;
                    } else {
                        try {
                            for (int i = 0; i < this.paramsArray.size(); ++i) {
                                Node contentNode = seoService.getContentNode(this.paramsArray.get(i).toString());
                                if (contentNode == null) continue;
                                this.metaModel = null;
                            }
                        }
                        catch (PathNotFoundException ex) {
                            this.metaModel = null;
                        }
                    }
                }
            } else {
                this.fullStatus = "Disabled";
            }
        }
        if (this.metaModel != null) {
            this.fullStatus = this.metaModel.getFullStatus();
        }
        super.processRender(context);
    }

    public String getFullStatus() {
        return this.fullStatus;
    }

    public static class AddSEOActionListener
    extends EventListener<UISEOToolbarForm> {
        public void execute(Event<UISEOToolbarForm> event) throws Exception {
            List seoLocales;
            UISEOToolbarForm uiSEOToolbar = (UISEOToolbarForm)((Object)event.getSource());
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            UISEOForm uiSEOForm = (UISEOForm)uiSEOToolbar.createUIComponent(UISEOForm.class, null, null);
            SEOService seoService = (SEOService)WCMCoreUtils.getService(SEOService.class);
            ArrayList<String> paramsArray = uiSEOToolbar.getParamsArray();
            if (paramsArray != null) {
                for (int i = 0; i < paramsArray.size(); ++i) {
                    Node contentNode = seoService.getContentNode(paramsArray.get(i));
                    if (contentNode == null) continue;
                    uiSEOForm.setOnContent(true);
                    uiSEOForm.setContentPath(paramsArray.get(i));
                    uiSEOForm.setContentURI(contentNode.getUUID());
                    break;
                }
                uiSEOToolbar.setMetaModel(seoService.getContentMetadata(paramsArray, uiSEOToolbar.lang));
            } else {
                uiSEOForm.setContentPath(uiSEOToolbar.getPageReference());
                uiSEOForm.setOnContent(false);
                uiSEOToolbar.setMetaModel(seoService.getPageMetadata(uiSEOToolbar.getPageReference(), uiSEOToolbar.lang));
            }
            uiSEOForm.setParamsArray(paramsArray);
            if (uiSEOToolbar.getMetaModel() == null && (seoLocales = seoService.getSEOLanguages(portalRequestContext.getPortalOwner(), uiSEOForm.getContentPath(), uiSEOForm.getOnContent())).size() > 0) {
                Locale locale = (Locale)seoLocales.get(0);
                StringBuffer sb = new StringBuffer();
                sb.append(locale.getLanguage());
                String country = locale.getCountry();
                if (StringUtils.isNotEmpty((String)country)) {
                    sb.append("_").append(country);
                }
                String lang = sb.toString();
                uiSEOToolbar.setMetaModel(seoService.getMetadata(uiSEOForm.getParamsArray(), uiSEOToolbar.getPageReference(), lang));
                uiSEOForm.setSelectedLanguage(lang);
            }
            uiSEOForm.initSEOForm(uiSEOToolbar.getMetaModel());
            Utils.createPopupWindow((UIContainer)uiSEOToolbar, (UIComponent)uiSEOForm, (String)UISEOToolbarForm.SEO_POPUP_WINDOW, (boolean)true, (int)640);
        }
    }
}

