/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.social;

import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class AnalyticsSpaceListener
extends SpaceListenerPlugin {
    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceAccessEdited");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceBannerEdited");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceCreated");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceRemoved");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceRenamed");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceDescriptionEdited");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void spaceRegistrationEdited(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceRegistrationEdited");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceAvatarEdited");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addApplicationStatisticEvent(event, "applicationActivated");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addApplicationStatisticEvent(event, "applicationAdded");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addApplicationStatisticEvent(event, "applicationDeactivated");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addApplicationStatisticEvent(event, "applicationRemoved");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addUserStatisticEvent(event, "grantedLead");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void joined(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addUserStatisticEvent(event, "joined");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void left(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addUserStatisticEvent(event, "left");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addUserStatisticEvent(event, "revokedLead");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addUserStatisticEvent(event, "addInvitedUser");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
        StatisticData statisticData = this.addUserStatisticEvent(event, "addPendingUser");
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private StatisticData addSpaceStatisticEvent(SpaceLifeCycleEvent event, String operation) {
        return this.buildStatisticData(operation, event.getSpace());
    }

    private StatisticData addApplicationStatisticEvent(SpaceLifeCycleEvent event, String operation) {
        Space space = event.getSpace();
        String applicationId = (String)event.getSource();
        StatisticData statisticData = this.buildStatisticData(operation, space);
        statisticData.addParameter("applicationId", (Object)applicationId);
        return statisticData;
    }

    private StatisticData addUserStatisticEvent(SpaceLifeCycleEvent event, String operation) {
        Space space = event.getSpace();
        return this.buildStatisticData(operation, space);
    }

    private StatisticData buildStatisticData(String operation, Space space) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("social");
        statisticData.setSubModule("space");
        statisticData.setOperation(operation);
        statisticData.setUserId(AnalyticsUtils.getCurrentUserIdentityId());
        AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        return statisticData;
    }
}

