/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.automatic.translation.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.automatic.translation.api.AutomaticTranslationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.simple.JSONObject;

@Path(value="/automatic-translation")
@Tag(name="/automatic-translation", description="Manage automatic translation operations")
public class AutomaticTranslationRestService
implements ResourceContainer {
    private AutomaticTranslationService automaticTranslationService;
    private static final Log LOG = ExoLogger.getLogger(AutomaticTranslationRestService.class);

    public AutomaticTranslationRestService(AutomaticTranslationService automaticTranslationService) {
        this.automaticTranslationService = automaticTranslationService;
    }

    @GET
    @Path(value="/configuration")
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets Automatic Translation configuration", method="GET", description="This returns the actual configuration for automatic translation")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Not authorized to get the configuration"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    public Response configuration() {
        return Response.ok((Object)this.automaticTranslationService.getConfiguration(), (String)"application/json").build();
    }

    @GET
    @Path(value="/isEnabled")
    @RolesAllowed(value={"users"})
    @Produces(value={"text/plain"})
    @Operation(summary="Gets status for Automatic Translation feature for users", method="GET", description="This returns is the automatic translation feature is active")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Unauthorized operation")})
    public Response isEnabled() {
        return Response.ok((Object)("" + this.automaticTranslationService.isFeatureActive())).build();
    }

    @PUT
    @Path(value="/setActiveConnector")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Operation(summary="Set Automatic translation active connector", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid Query Input"), @ApiResponse(responseCode="401", description="Not authorized to change the connector"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    public Response setActiveConnector(@Parameter(description="Connector name", required=true) @QueryParam(value="connector") String connector) {
        connector = connector == null || connector.equals("null") ? "" : connector;
        try {
            this.automaticTranslationService.setActiveConnector(connector);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Unable to set active connector", (Throwable)e);
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/setApiKey")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Operation(summary="Set Automatic translation API key", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid Query Input"), @ApiResponse(responseCode="401", description="Not authorized to change the apiKey"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    public Response setApiKey(@Parameter(description="Connector name", required=true) @QueryParam(value="connector") String connector, @Parameter(description="Api Key", required=true) @QueryParam(value="apikey") String apikey) {
        connector = connector == null || connector.equals("null") ? "" : connector;
        try {
            this.automaticTranslationService.setApiKey(connector, apikey);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Unable to set api key connector", (Throwable)e);
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/translate")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="translate message passed in parameter", method="GET", description="This returns the message transalted in the asked locale, by using the active connector")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid Query Input"), @ApiResponse(responseCode="401", description="Not authorized to use translation"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    public Response translate(@Parameter(description="message", required=true) @FormParam(value="message") String message, @Parameter(description="locale", required=true) @FormParam(value="locale") String localeParam, @Parameter(description="contentType") @FormParam(value="contentType") String contentType, @Parameter(description="spaceId") @FormParam(value="spaceId") long spaceId) {
        Locale locale = Locale.forLanguageTag(localeParam.replace("_", "-"));
        if (locale == null) {
            return Response.status((int)400).entity((Object)"Locale is not recognized").build();
        }
        String translatedMessage = this.automaticTranslationService.translate(message, locale, contentType, spaceId);
        if (translatedMessage != null) {
            JSONObject resultJSON = new JSONObject();
            resultJSON.put((Object)"locale", (Object)locale.toString());
            resultJSON.put((Object)"translation", (Object)translatedMessage);
            return Response.ok((Object)resultJSON.toString(), (String)"application/json").build();
        }
        return Response.status((int)400).build();
    }
}

