/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.rest.EntityBuilder;
import org.exoplatform.addons.gamification.rest.model.ChallengeRestEntity;
import org.exoplatform.addons.gamification.rest.model.DomainWithChallengesRestEntity;
import org.exoplatform.addons.gamification.service.AnnouncementService;
import org.exoplatform.addons.gamification.service.ChallengeService;
import org.exoplatform.addons.gamification.service.configuration.DomainService;
import org.exoplatform.addons.gamification.service.dto.configuration.Announcement;
import org.exoplatform.addons.gamification.service.dto.configuration.Challenge;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.DateFilterType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityFilterType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityStatusType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.PeriodType;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/gamification/challenges")
@Tag(name="/challenge/api", description="Manages challenge associated to users")
@RolesAllowed(value={"users"})
public class ChallengeRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ChallengeRest.class);
    private DomainService domainService;
    private ChallengeService challengeService;
    private AnnouncementService announcementService;

    public ChallengeRest(ChallengeService challengeService, AnnouncementService announcementService, DomainService domainService) {
        this.challengeService = challengeService;
        this.domainService = domainService;
        this.announcementService = announcementService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a new challenge", method="POST", description="Creates a new challenge")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createChallenge(@RequestBody(description="Challenge object to create", required=true) Challenge challenge) {
        if (challenge == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"challenge object is mandatory").build();
        }
        String currentUser = Utils.getCurrentUser();
        if (StringUtils.isBlank((CharSequence)currentUser)) {
            LOG.warn((Object)"current User is null");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            Challenge newChallenge = this.challengeService.createChallenge(challenge, currentUser);
            return Response.ok((Object)EntityBuilder.fromChallenge(newChallenge, Collections.emptyList())).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to create a challenge while not authorized", new Object[]{currentUser});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{challengeId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves a challenge by its id", method="GET", description="returns selected challenge if exists")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getChallengeById(@Parameter(description="Challenge technical id", required=true) @PathParam(value="challengeId") long challengeId, @Parameter(description="Offset of result") @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit of result") @DefaultValue(value="10") @QueryParam(value="limit") int limit) {
        if (challengeId == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty challengeId");
            return Response.status((int)400).build();
        }
        String currentUser = Utils.getCurrentUser();
        try {
            Challenge challenge = this.challengeService.getChallengeById(challengeId, currentUser);
            if (challenge == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            List<Announcement> announcementList = this.announcementService.findAllAnnouncementByChallenge(challengeId, offset, limit, PeriodType.ALL, null);
            return Response.ok((Object)EntityBuilder.fromChallenge(challenge, announcementList, false)).build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to retrieve a challenge by id '{}'", new Object[]{currentUser, challengeId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates an existing challenge", method="PUT", description="Updates an existing challenge")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateChallenge(@RequestBody(description="challenge object to update", required=true) Challenge challenge) {
        if (challenge == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"challenge object is mandatory").build();
        }
        if (challenge.getId() <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"challenge technical identifier must be positive").build();
        }
        String currentUser = Utils.getCurrentUser();
        try {
            challenge = this.challengeService.updateChallenge(challenge, currentUser);
            return Response.ok((Object)EntityBuilder.fromChallenge(challenge, Collections.emptyList())).build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to update a not existing challenge '{}'", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Challenge not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to update a challenge for owner '{}'", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of challenges available for an owner", method="GET", description="Retrieves the list of challenges available for an owner")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getAllChallengesByUser(@Parameter(description="Offset of result") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit of result") @Schema(defaultValue="10") @QueryParam(value="limit") int limit, @Parameter(description="Group challenges by domain") @Schema(defaultValue="false") @QueryParam(value="groupByDomain") boolean groupByDomain, @Parameter(description="Used to filter challenges by domain") @Schema(defaultValue="") @QueryParam(value="domainId") long domainId, @Parameter(description="Number of announcements per challenge") @Schema(defaultValue="0") @QueryParam(value="announcements") int announcementsPerChallenge, @Parameter(description="term to search challenges with") @QueryParam(value="term") String term, @Parameter(description="Challenge period filtering. Possible values: STARTED, NOT_STARTED, ENDED, ALL") @Schema(defaultValue="ALL") @DefaultValue(value="ALL") @QueryParam(value="filter") String dateFilterType, @Parameter(description="is popular challenges") @DefaultValue(value="false") @QueryParam(value="orderByRealizations") boolean orderByRealizations, @Parameter(description="Excluded challenges Ids", required=false) @QueryParam(value="excludedChallengesIds") List<Long> excludedChallengesIds, @Parameter(description="Challenge period filtering. Possible values: WEEK, MONTH, YEAR, ALL") @Schema(defaultValue="ALL") @DefaultValue(value="ALL") @QueryParam(value="period") String period) {
        String currentUser = Utils.getCurrentUser();
        RuleFilter filter = new RuleFilter();
        filter.setTerm(term);
        filter.setUsername(currentUser);
        filter.setDateFilterType(DateFilterType.valueOf(dateFilterType));
        filter.setOrderByRealizations(orderByRealizations);
        PeriodType periodType = PeriodType.valueOf(period);
        if (excludedChallengesIds != null && !excludedChallengesIds.isEmpty()) {
            filter.setExcludedChallengesIds(excludedChallengesIds);
        }
        try {
            LOG.debug((Object)"start getting challenges");
            if (domainId > 0L) {
                filter.setDomainId(domainId);
                List<ChallengeRestEntity> challengeRestEntities = this.getUserChallengesByDomain(filter, currentUser, offset, limit, announcementsPerChallenge, false);
                LOG.debug((Object)"ended mapping challenges");
                return Response.ok(challengeRestEntities).build();
            }
            if (groupByDomain) {
                DomainFilter domainFilter = new DomainFilter();
                domainFilter.setEntityFilterType(EntityFilterType.ALL);
                domainFilter.setEntityStatusType(EntityStatusType.ENABLED);
                List<DomainDTO> domains = this.domainService.getDomainsByFilter(domainFilter, currentUser, 0, -1);
                ArrayList<DomainWithChallengesRestEntity> domainsWithChallenges = new ArrayList<DomainWithChallengesRestEntity>();
                for (DomainDTO domain : domains) {
                    DomainWithChallengesRestEntity domainWithChallenge = new DomainWithChallengesRestEntity(domain);
                    filter.setDomainId(domain.getId());
                    List<ChallengeRestEntity> challengeRestEntities = this.getUserChallengesByDomain(filter, currentUser, offset, limit, announcementsPerChallenge, true);
                    domainWithChallenge.setChallenges(challengeRestEntities);
                    domainWithChallenge.setChallengesOffset(offset);
                    domainWithChallenge.setChallengesLimit(limit);
                    int size = this.challengeService.countChallengesByFilterAndUser(filter, currentUser);
                    domainWithChallenge.setChallengesSize(size);
                    domainsWithChallenges.add(domainWithChallenge);
                }
                return Response.ok(domainsWithChallenges).build();
            }
            List<Challenge> challenges = this.challengeService.getChallengesByFilterAndUser(filter, offset, limit, currentUser);
            ArrayList<ChallengeRestEntity> challengeRestEntities = new ArrayList<ChallengeRestEntity>();
            LOG.debug((Object)"start mapping challenges");
            for (Challenge challenge : challenges) {
                challengeRestEntities.add(EntityBuilder.fromChallenge(this.announcementService, challenge, announcementsPerChallenge, false, periodType));
            }
            LOG.debug((Object)"ended mapping challenges");
            return Response.ok(challengeRestEntities).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized challenges with owner Ids", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="canAddChallenge")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Operation(summary="check if the current user can add a challenge", method="GET", description="This checks if the current user user can add a challenge")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User ability to add a challenge is returned"), @ApiResponse(responseCode="401", description="User not authorized to add a challenge")})
    public Response canAddChallenge() {
        boolean canAddChallenge = Utils.isSuperManager(ConversationState.getCurrent().getIdentity().getUserId());
        return Response.ok((Object)String.valueOf(canAddChallenge)).build();
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="check if the current user can add a challenge", method="GET", description="This checks if the current user user can add a challenge")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="challenge deleted"), @ApiResponse(responseCode="401", description="User not authorized to delete a challenge"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteChallenge(@Parameter(description="challenge id to be deleted", required=true) @PathParam(value="id") Long challengeId) {
        if (challengeId == null || challengeId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"challenge technical identifier must be positive").build();
        }
        String currentUser = Utils.getCurrentUser();
        try {
            this.challengeService.deleteChallenge(challengeId, currentUser);
            return Response.ok().build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"The challenge doesn't exist").build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} is not authorized to delete challenge with id {}", new Object[]{currentUser, challengeId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"unauthorized user trying to delete a challenge").build();
        }
    }

    private List<ChallengeRestEntity> getUserChallengesByDomain(RuleFilter filter, String currentUser, int offset, int limit, int announcementsPerChallenge, boolean noDomain) throws IllegalAccessException {
        List<Challenge> challenges = this.challengeService.getChallengesByFilterAndUser(filter, offset, limit, currentUser);
        ArrayList<ChallengeRestEntity> challengeRestEntities = new ArrayList<ChallengeRestEntity>();
        LOG.debug((Object)"start mapping challenges");
        for (Challenge challenge : challenges) {
            challengeRestEntities.add(EntityBuilder.fromChallenge(this.announcementService, challenge, announcementsPerChallenge, noDomain, PeriodType.ALL));
        }
        return challengeRestEntities;
    }
}

