/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.effective;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.GamificationActionsHistoryDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.HistoryStatus;
import org.exoplatform.addons.gamification.service.effective.LeaderboardFilter;
import org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard;
import org.exoplatform.addons.gamification.service.effective.ProfileReputation;
import org.exoplatform.addons.gamification.service.effective.StandardLeaderboard;
import org.exoplatform.addons.gamification.service.mapper.GamificationActionsHistoryMapper;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GamificationService {
    private static final Log LOG = ExoLogger.getLogger(GamificationService.class);
    protected final GamificationHistoryDAO gamificationHistoryDAO;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private RuleService ruleService;

    public GamificationService(IdentityManager identityManager, SpaceService spaceService, GamificationHistoryDAO gamificationHistoryDAO, RuleService ruleService) {
        this.gamificationHistoryDAO = gamificationHistoryDAO;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.ruleService = ruleService;
    }

    public List<GamificationActionsHistory> findActionHistoryByDateByEarnerId(Date date, String earnerId) {
        return this.gamificationHistoryDAO.findActionHistoryByDateByEarnerId(date, earnerId);
    }

    public int getLeaderboardRank(String earnerId, Date date, Long domainId) {
        List<StandardLeaderboard> leaderboard = null;
        Identity identity = this.identityManager.getIdentity(earnerId);
        IdentityType identityType = IdentityType.getType(identity.getProviderId());
        leaderboard = date != null ? (domainId == null || domainId <= 0L ? this.gamificationHistoryDAO.findAllActionsHistoryByDate(identityType, date) : this.gamificationHistoryDAO.findAllActionsHistoryByDateByDomain(identityType, date, domainId)) : (domainId == null || domainId <= 0L ? this.gamificationHistoryDAO.findAllActionsHistoryAgnostic(identityType) : this.gamificationHistoryDAO.findAllActionsHistoryByDomain(identityType, domainId));
        StandardLeaderboard item = leaderboard.stream().filter((? super T g) -> earnerId.equals(g.getEarnerId())).findAny().orElse(null);
        return leaderboard.indexOf(item) + 1;
    }

    public long findReputationByEarnerId(String earnerId) {
        GamificationActionsHistory aHistory = this.findLatestActionHistoryByEarnerId(earnerId);
        return aHistory != null ? aHistory.getGlobalScore() : 0L;
    }

    public List<ProfileReputation> buildDomainScoreByIdentityId(String earnerId) {
        return this.gamificationHistoryDAO.findDomainScoreByIdentityId(earnerId);
    }

    public GamificationActionsHistory saveActionHistory(GamificationActionsHistory history) {
        return (GamificationActionsHistory)this.gamificationHistoryDAO.create(history);
    }

    public void createHistory(String event, String sender, String receiver, String object) {
        GamificationActionsHistory aHistory = null;
        List<RuleDTO> ruleDtos = null;
        ruleDtos = this.ruleService.findEnabledRulesByEvent(event);
        if (ruleDtos != null) {
            for (RuleDTO ruleDto : ruleDtos) {
                aHistory = this.build(ruleDto, sender, receiver, object);
                if (aHistory == null) continue;
                aHistory = this.saveActionHistory(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getEarnerId(), aHistory.getGlobalScore(), ruleDto.getDomainDTO().getTitle(), ruleDto.getEvent(), ruleDto.getScore()});
            }
        }
    }

    public GamificationActionsHistory findLatestActionHistoryByEarnerId(String earnerId) {
        List<GamificationActionsHistory> entities = this.gamificationHistoryDAO.findActionsHistoryByEarnerId(earnerId, 1);
        return entities != null && !entities.isEmpty() ? entities.get(0) : null;
    }

    public List<StandardLeaderboard> filter(LeaderboardFilter filter) {
        String currentUser;
        int limit = filter.getLoadCapacity();
        IdentityType identityType = filter.getIdentityType();
        if (identityType.isSpace()) {
            limit *= 3;
        }
        List<StandardLeaderboard> result = null;
        if (filter.getDomainId() == null || filter.getDomainId() <= 0L) {
            now = LocalDate.now();
            if (filter.getPeriod().equals(LeaderboardFilter.Period.WEEK.name())) {
                Date fromDate = Date.from(now.with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
                result = this.gamificationHistoryDAO.findAllActionsHistoryByDate(fromDate, identityType, limit);
            } else if (filter.getPeriod().equals(LeaderboardFilter.Period.MONTH.name())) {
                Date fromDate = Date.from(now.with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                result = this.gamificationHistoryDAO.findAllActionsHistoryByDate(fromDate, identityType, limit);
            } else {
                result = this.gamificationHistoryDAO.findAllActionsHistory(identityType, limit);
            }
        } else {
            now = LocalDate.now();
            if (filter.getPeriod().equals(LeaderboardFilter.Period.WEEK.name())) {
                Date fromDate = Date.from(now.with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
                result = this.gamificationHistoryDAO.findActionsHistoryByDateByDomain(fromDate, identityType, filter.getDomainId(), limit);
            } else if (filter.getPeriod().equals(LeaderboardFilter.Period.MONTH.name())) {
                Date fromDate = Date.from(now.with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                result = this.gamificationHistoryDAO.findActionsHistoryByDateByDomain(fromDate, identityType, filter.getDomainId(), limit);
            } else {
                result = this.gamificationHistoryDAO.findAllActionsHistoryByDomain(filter.getDomainId(), identityType, limit);
            }
        }
        if (identityType.isSpace() && result != null && !result.isEmpty() && StringUtils.isNotBlank((CharSequence)(currentUser = filter.getCurrentUser()))) {
            result = this.filterAuthorizedSpaces(result, currentUser, filter.getLoadCapacity());
        }
        return result;
    }

    public List<PiechartLeaderboard> buildStatsByUser(String earnerId, Date startDate, Date endDate) {
        return this.gamificationHistoryDAO.findStatsByUserId(earnerId, startDate, endDate);
    }

    public long findUserReputationScoreBetweenDate(String earnerId, Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.findUserReputationScoreBetweenDate(earnerId, fromDate, toDate);
    }

    public Map<Long, Long> findUsersReputationScoreBetweenDate(List<String> earnersId, Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.findUsersReputationScoreBetweenDate(earnersId, fromDate, toDate);
    }

    public List<StandardLeaderboard> findAllLeaderboardBetweenDate(IdentityType earnedType, Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.findAllLeaderboardBetweenDate(earnedType, fromDate, toDate);
    }

    public List<GamificationActionsHistory> findActionsHistoryByEarnerId(String earnerId, int limit) {
        return this.gamificationHistoryDAO.findActionsHistoryByEarnerIdSortedByDate(earnerId, limit);
    }

    public GamificationActionsHistory build(RuleDTO ruleDto, String actor, String receiver, String objectId) {
        GamificationActionsHistory aHistory = null;
        Identity actorIdentity = this.identityManager.getIdentity(actor);
        if (actorIdentity == null || StringUtils.isBlank((CharSequence)actorIdentity.getRemoteId())) {
            LOG.warn("Actor {} has earned some points but doesn't have a social identity", new Object[]{actor});
            return null;
        }
        if (actorIdentity.isDeleted()) {
            LOG.warn("Actor {} has earned some points but is marked as deleted", new Object[]{actor});
            return null;
        }
        if (!actorIdentity.isEnable()) {
            LOG.warn("Actor {} has earned some points but is marked as disabled", new Object[]{actor});
            return null;
        }
        if (Utils.isUserMemberOfGroupOrUser(actorIdentity.getRemoteId(), "/leaderboard-blacklist-users")) {
            LOG.debug("Actor {} cannot earn points since has been blacklisted", new Object[]{actor});
            return null;
        }
        if (ruleDto != null) {
            DomainDTO domainDTO = ruleDto.getDomainDTO();
            if (domainDTO != null) {
                long audienceId = domainDTO.getAudienceId();
                if (domainDTO.isDeleted() || audienceId == 0L || audienceId > 0L && actorIdentity.isUser() && !Utils.isSpaceMember(audienceId, actorIdentity.getRemoteId())) {
                    LOG.info("Actor {} cannot earn points since he is not a member of the domain audience", new Object[]{actor});
                    return null;
                }
            }
            GamificationActionsHistoryDTO actionsHistoryDTO = new GamificationActionsHistoryDTO();
            actionsHistoryDTO.setActionScore(ruleDto.getScore());
            actionsHistoryDTO.setGlobalScore(this.computeTotalScore(actor) + (long)ruleDto.getScore());
            actionsHistoryDTO.setEarnerId(actor);
            actionsHistoryDTO.setEarnerType(actorIdentity.getProviderId());
            actionsHistoryDTO.setActionTitle(ruleDto.getTitle());
            actionsHistoryDTO.setRuleId(ruleDto.getId());
            if (ruleDto.getDomainDTO() != null) {
                actionsHistoryDTO.setDomainDTO(ruleDto.getDomainDTO());
            }
            actionsHistoryDTO.setReceiver(receiver);
            actionsHistoryDTO.setObjectId(objectId);
            actionsHistoryDTO.setStatus(HistoryStatus.ACCEPTED.name());
            actionsHistoryDTO.setType(ruleDto.getType());
            return GamificationActionsHistoryMapper.toEntity(actionsHistoryDTO);
        }
        return aHistory;
    }

    public long computeTotalScore(String actorIdentityId) {
        return this.gamificationHistoryDAO.getTotalScore(actorIdentityId);
    }

    private List<StandardLeaderboard> filterAuthorizedSpaces(List<StandardLeaderboard> result, String currentUser, int limit) {
        result = result.stream().filter((? super T spacePoint) -> {
            String spaceIdentityId = spacePoint.getEarnerId();
            Identity identity = this.identityManager.getIdentity(spaceIdentityId);
            if (identity == null) {
                LOG.debug("Space Identity with id {} was deleted, ignore it", new Object[]{spaceIdentityId});
                return false;
            }
            String spacePrettyName = identity.getRemoteId();
            Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
            return space != null && (!"hidden".equals(space.getVisibility()) || this.spaceService.isMember(space, currentUser));
        }).limit(limit).collect(Collectors.toList());
        return result;
    }
}

