/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.dto.configuration.RealizationsFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.HistoryStatus;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.PeriodType;
import org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard;
import org.exoplatform.addons.gamification.service.effective.ProfileReputation;
import org.exoplatform.addons.gamification.service.effective.StandardLeaderboard;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class GamificationHistoryDAO
extends GenericDAOJPAImpl<GamificationActionsHistory, Long> {
    private static final String TO_DATE_PARAM_NAME = "toDate";
    private static final String FROM_DATE_PARAM_NAME = "fromDate";
    private static final String NOW_DATE_PARAM_NAME = "nowDate";
    private static final String EARNER_ID_PARAM_NAME = "earnerId";
    private static final String EARNER_IDS_PARAM_NAME = "earnerIds";
    private static final String DOMAIN_IDS_PARAM_NAME = "domainIds";
    private static final String DOMAIN_ID_PARAM_NAME = "domainId";
    private static final String EARNER_TYPE_PARAM_NAME = "earnerType";
    public static final String STATUS = "status";
    public static final String TYPE = "type";
    private static final String CHALLENGE_ID_PARAM_NAME = "challengeId";
    private final Map<String, Boolean> filterNamedQueries = new HashMap<String, Boolean>();

    public List<StandardLeaderboard> findAllActionsHistoryAgnostic(IdentityType earnerType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistory", StandardLeaderboard.class);
        query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDateByDomain(IdentityType earnerType, Date date, long domainId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistoryByDateByDomain", StandardLeaderboard.class);
        query.setParameter("date", (Object)date).setParameter(DOMAIN_ID_PARAM_NAME, (Object)domainId).setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        return query.getResultList();
    }

    public List<GamificationActionsHistory> findActionsHistoryByEarnerIdAndByType(String earnerId, EntityType type) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByEarnerIdAndByType", GamificationActionsHistory.class);
        query.setParameter(TYPE, (Object)type);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)earnerId);
        return query.getResultList();
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDomain(IdentityType earnerType, long domainId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistoryByDomain", StandardLeaderboard.class);
        query.setParameter(DOMAIN_ID_PARAM_NAME, (Object)domainId);
        query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        return query.getResultList();
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDomain(long domainId, IdentityType earnerType, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistoryByDomain", StandardLeaderboard.class);
        query.setParameter(DOMAIN_ID_PARAM_NAME, (Object)domainId);
        query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType);
        query.setMaxResults(limit);
        return Collections.emptyList();
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDate(IdentityType earnerType, Date date) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByDate", StandardLeaderboard.class);
        query.setParameter("date", (Object)date);
        query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        return query.getResultList();
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDate(Date date, IdentityType earnerType, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByDate", StandardLeaderboard.class);
        query.setParameter("date", (Object)date);
        query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public List<GamificationActionsHistory> findActionsHistoryByEarnerId(String earnerId, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByEarnerId", GamificationActionsHistory.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)earnerId);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public List<StandardLeaderboard> findAllActionsHistory(IdentityType earnerType, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistory", StandardLeaderboard.class);
        query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public List<GamificationActionsHistory> findActionHistoryByDateByEarnerId(Date date, String earnerId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionHistoryByDateByEarnerId", GamificationActionsHistory.class).setParameter("date", (Object)date).setParameter(EARNER_ID_PARAM_NAME, (Object)earnerId);
        return query.getResultList();
    }

    public List<StandardLeaderboard> findActionsHistoryByDateByDomain(Date date, IdentityType earnerType, long domainId, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByDateByDomain", StandardLeaderboard.class);
        query.setParameter("date", (Object)date).setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType).setParameter(DOMAIN_ID_PARAM_NAME, (Object)domainId);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public List<PiechartLeaderboard> findStatsByUserId(String earnerId, Date fromDate, Date toDate) {
        TypedQuery query = null;
        if (fromDate != null && toDate != null) {
            query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findStatsByUserByDates", PiechartLeaderboard.class);
            query.setParameter(EARNER_ID_PARAM_NAME, (Object)earnerId).setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate).setParameter(TO_DATE_PARAM_NAME, (Object)toDate);
        } else {
            query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findStatsByUser", PiechartLeaderboard.class);
            query.setParameter(EARNER_ID_PARAM_NAME, (Object)earnerId);
        }
        return query.getResultList();
    }

    public List<ProfileReputation> findDomainScoreByIdentityId(String earnerId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findDomainScoreByUserId", ProfileReputation.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)earnerId);
        return query.getResultList();
    }

    public long findUserReputationScoreBetweenDate(String earnerId, Date fromDate, Date toDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUserReputationScoreBetweenDate", Long.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)earnerId).setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate).setParameter(TO_DATE_PARAM_NAME, (Object)toDate);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        Long count = (Long)query.getSingleResult();
        return count == null ? 0L : count;
    }

    public Map<Long, Long> findUsersReputationScoreBetweenDate(List<String> earnersId, Date fromDate, Date toDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUsersReputationScoreBetweenDate", Tuple.class);
        query.setParameter("earnersId", earnersId).setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate).setParameter(TO_DATE_PARAM_NAME, (Object)toDate);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        return query.getResultList().stream().collect(Collectors.toMap(tuple -> Long.valueOf((String)tuple.get(0)), tuple -> (Long)tuple.get(1)));
    }

    public long findUserReputationScoreByMonth(String earnerId, Date currentMonth) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUserReputationScoreByMonth", Long.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)earnerId).setParameter("currentMonth", (Object)currentMonth);
        Long count = (Long)query.getSingleResult();
        return count == null ? 0L : count;
    }

    public long findUserReputationScoreByDomainBetweenDate(String earnerId, long domainId, Date fromDate, Date toDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUserReputationScoreByDomainBetweenDate", Long.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)earnerId).setParameter(DOMAIN_ID_PARAM_NAME, (Object)domainId).setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate).setParameter(TO_DATE_PARAM_NAME, (Object)toDate);
        Long count = (Long)query.getSingleResult();
        return count == null ? 0L : count;
    }

    public List<StandardLeaderboard> findAllLeaderboardBetweenDate(IdentityType earnerType, Date fromDate, Date toDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllLeaderboardBetweenDate", StandardLeaderboard.class);
        query.setParameter(FROM_DATE_PARAM_NAME, (Object)fromDate).setParameter(TO_DATE_PARAM_NAME, (Object)toDate).setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType);
        return query.getResultList();
    }

    public List<GamificationActionsHistory> findActionsHistoryByEarnerIdSortedByDate(String earnerId, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByEarnerIdSortedByDate", GamificationActionsHistory.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)earnerId);
        query.setMaxResults(limit);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        return query.getResultList();
    }

    public long getTotalScore(String earnerId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.computeTotalScore", Long.class);
        query.setParameter(EARNER_ID_PARAM_NAME, (Object)earnerId);
        Long count = (Long)query.getSingleResult();
        return count == null ? 0L : count;
    }

    public List<GamificationActionsHistory> getAllPointsByDomain(long domainId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.getAllPointsByDomain", GamificationActionsHistory.class);
        query.setParameter(DOMAIN_ID_PARAM_NAME, (Object)domainId);
        return query.getResultList();
    }

    public Long countAnnouncementsByChallenge(Long challengeId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.countAnnouncementsByChallenge", Long.class);
        query.setParameter(CHALLENGE_ID_PARAM_NAME, (Object)challengeId);
        try {
            Long count = (Long)query.getSingleResult();
            return count == null ? 0L : count;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public Long countAnnouncementsByChallengeAndEarnerType(Long challengeId, IdentityType earnerType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.countAnnouncementsByChallengeAndEarnerType", Long.class);
        query.setParameter(CHALLENGE_ID_PARAM_NAME, (Object)challengeId);
        query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType);
        try {
            Long count = (Long)query.getSingleResult();
            return count == null ? 0L : count;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public List<GamificationActionsHistory> findAllAnnouncementByChallenge(Long challengeId, int offset, int limit, PeriodType periodType, IdentityType earnerType) {
        List resultList;
        TypedQuery query = null;
        if (periodType != null && periodType.equals((Object)PeriodType.WEEK)) {
            if (earnerType != null) {
                query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllAnnouncementByChallengeByDateByEarnerType", GamificationActionsHistory.class);
                query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType);
            } else {
                query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllAnnouncementByChallengeByDate", GamificationActionsHistory.class);
            }
            LocalDate monday = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
            LocalDate sunday = LocalDate.now().with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
            Date utilFromDate = Date.from(monday.atStartOfDay(ZoneId.systemDefault()).toInstant());
            Date utilToDate = Date.from(sunday.atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant());
            query.setParameter(FROM_DATE_PARAM_NAME, (Object)utilFromDate).setParameter(TO_DATE_PARAM_NAME, (Object)utilToDate);
        } else if (earnerType != null) {
            query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllAnnouncementByChallengeByEarnerType", GamificationActionsHistory.class);
            query.setParameter(EARNER_TYPE_PARAM_NAME, (Object)earnerType);
        } else {
            query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllAnnouncementByChallenge", GamificationActionsHistory.class);
        }
        query.setParameter(CHALLENGE_ID_PARAM_NAME, (Object)challengeId);
        if (offset >= 0) {
            query.setFirstResult(offset);
        }
        if (limit >= 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<Long> findMostRealizedRuleIds(List<Long> spacesIds, int offset, int limit, EntityType type) {
        List resultList = null;
        if (CollectionUtils.isNotEmpty(spacesIds)) {
            TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findMostRealizedRuleIds", Long.class);
            query.setParameter("spacesIds", spacesIds);
            LocalDate monday = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
            LocalDate sunday = LocalDate.now().with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
            Date utilFromDate = Date.from(monday.atStartOfDay(ZoneId.systemDefault()).toInstant());
            Date utilToDate = Date.from(sunday.atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant());
            Date now = Date.from(ZonedDateTime.now(ZoneOffset.UTC).toInstant());
            query.setParameter(FROM_DATE_PARAM_NAME, (Object)utilFromDate).setParameter(TO_DATE_PARAM_NAME, (Object)utilToDate).setParameter(TYPE, (Object)type).setParameter(NOW_DATE_PARAM_NAME, (Object)now);
            query.setFirstResult(offset);
            query.setMaxResults(limit);
            resultList = query.getResultList();
        }
        return resultList == null ? Collections.emptyList() : resultList;
    }

    public List<GamificationActionsHistory> findRealizationsByFilter(RealizationsFilter realizationFilter, int offset, int limit) {
        TypedQuery<GamificationActionsHistory> query = this.buildQueryFromFilter(realizationFilter, GamificationActionsHistory.class, false);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query.getResultList();
    }

    public int countRealizationsByFilter(RealizationsFilter filter) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, true);
        return ((Long)query.getSingleResult()).intValue();
    }

    private <T> TypedQuery<T> buildQueryFromFilter(RealizationsFilter filter, Class<T> clazz, boolean count) {
        TypedQuery query;
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> predicates = new ArrayList<String>();
        this.buildPredicates(filter, suffixes, predicates);
        String queryName = this.getQueryFilterName(suffixes, count);
        if (this.filterNamedQueries.containsKey(queryName)) {
            query = this.getEntityManager().createNamedQuery(queryName, clazz);
        } else {
            String queryContent = this.getQueryFilterContent(filter, predicates, count);
            query = this.getEntityManager().createQuery(queryContent, clazz);
            this.getEntityManager().getEntityManagerFactory().addNamedQuery(queryName, (Query)query);
            this.filterNamedQueries.put(queryName, true);
        }
        this.addQueryFilterParameters(filter, query);
        return query;
    }

    private void buildPredicates(RealizationsFilter filter, List<String> suffixes, List<String> predicates) {
        predicates.add("g.earnerType = :type");
        suffixes.add(filter.getSortField());
        suffixes.add(filter.isSortDescending() ? "Descending" : "Ascending");
        if (filter.getFromDate() != null && filter.getToDate() != null) {
            suffixes.add("Interval");
            predicates.add("g.createdDate >= :fromDate AND g.createdDate < :toDate");
        }
        if (CollectionUtils.isNotEmpty(filter.getEarnerIds())) {
            suffixes.add("Earner");
            predicates.add("g.earnerId IN (:earnerIds)");
        }
        if (!filter.getDomainIds().isEmpty()) {
            suffixes.add("searchByProgramIds" + filter.getDomainIds());
            predicates.add("g.domainEntity.id IN (:domainIds)");
        }
    }

    private String getQueryFilterName(List<String> suffixes, boolean count) {
        Object queryName = suffixes.isEmpty() ? (count ? "GamificationActionsHistory.countRealizations" : "GamificationActionsHistory.findRealizations") : (count ? "GamificationActionsHistory.countRealizations" : "GamificationActionsHistory.findRealizations") + "By" + StringUtils.join(suffixes, (String)"By");
        return queryName;
    }

    private String getQueryFilterContent(RealizationsFilter filter, List<String> predicates, boolean count) {
        String querySelect = count ? "SELECT COUNT(g) FROM GamificationActionsHistory g " : "SELECT DISTINCT g FROM GamificationActionsHistory g ";
        String orderBy = null;
        String sortDirection = filter.isSortDescending() ? " DESC" : " ASC";
        orderBy = StringUtils.equals((CharSequence)filter.getSortField(), (CharSequence)"date") || StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{filter.getSortField()}) ? " ORDER BY g.id " + sortDirection : " ORDER BY g." + filter.getSortField() + sortDirection + " ,g.id DESC ";
        Object queryContent = predicates.isEmpty() ? querySelect : querySelect + " WHERE " + StringUtils.join(predicates, (String)" AND ");
        if (!count) {
            queryContent = (String)queryContent + orderBy;
        }
        return queryContent;
    }

    private <T> void addQueryFilterParameters(RealizationsFilter filter, TypedQuery<T> query) {
        query.setParameter(FROM_DATE_PARAM_NAME, (Object)filter.getFromDate());
        query.setParameter(TO_DATE_PARAM_NAME, (Object)filter.getToDate());
        if (CollectionUtils.isNotEmpty(filter.getEarnerIds())) {
            query.setParameter(EARNER_IDS_PARAM_NAME, filter.getEarnerIds());
        }
        if (CollectionUtils.isNotEmpty(filter.getDomainIds())) {
            query.setParameter(DOMAIN_IDS_PARAM_NAME, filter.getDomainIds());
        }
        query.setParameter(TYPE, (Object)filter.getIdentityType());
    }
}

