/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.container;

import javax.portlet.Portlet;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.portlet.container.PortletContainer;
import org.gatein.pc.portlet.container.PortletContainerContext;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.managed.ManagedPortletContainer;
import org.gatein.pc.portlet.container.object.PortletContainerObject;
import org.gatein.pc.portlet.impl.container.DependencyNotResolvedException;
import org.gatein.pc.portlet.impl.container.LifeCycle;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletFilterLifeCycle;

public class PortletContainerLifeCycle
extends LifeCycle
implements ManagedPortletContainer {
    private PortletApplicationLifeCycle portletApplicationLifeCycle;
    final PortletContainerContext portletContainerContext;
    final PortletContainerObject portletContainer;

    PortletContainerLifeCycle(PortletApplicationLifeCycle portletApplicationLifeCycle, PortletContainerContext portletContainerContext, PortletContainerObject portletContainer) {
        this.portletApplicationLifeCycle = portletApplicationLifeCycle;
        this.portletContainerContext = portletContainerContext;
        this.portletContainer = portletContainer;
    }

    @Override
    protected void invokeCreate() throws Exception {
        if (this.portletApplicationLifeCycle.getStatus().getStage() < LifeCycleStatus.CREATED.getStage()) {
            throw new DependencyNotResolvedException("The parent application is not created");
        }
        for (PortletFilterLifeCycle portletFilterLifeCycle : this.portletApplicationLifeCycle.getDependencies(this)) {
            if (portletFilterLifeCycle.getStatus().getStage() >= LifeCycleStatus.CREATED.getStage()) continue;
            throw new DependencyNotResolvedException("The filter " + portletFilterLifeCycle + " is not created");
        }
        this.portletContainer.create();
    }

    @Override
    protected void invokeStart() throws Exception {
        if (this.portletApplicationLifeCycle.getStatus().getStage() < LifeCycleStatus.STARTED.getStage()) {
            throw new DependencyNotResolvedException("The parent application is not started");
        }
        for (PortletFilterLifeCycle portletFilterLifeCycle : this.portletApplicationLifeCycle.getDependencies(this)) {
            if (portletFilterLifeCycle.getStatus().getStage() >= LifeCycleStatus.STARTED.getStage()) continue;
            throw new DependencyNotResolvedException("The filter " + portletFilterLifeCycle + " is not started");
        }
        this.portletContainer.start();
    }

    @Override
    protected void invokeStop() {
        this.portletContainer.stop();
    }

    @Override
    public Portlet getPortletInstance() {
        return this.portletContainer.getPortletInstance();
    }

    @Override
    protected void invokeDestroy() throws Exception {
        this.portletContainer.destroy();
    }

    @Override
    public String getId() {
        return this.portletContainer.getId();
    }

    @Override
    public PortletInfo getInfo() {
        return this.portletContainer.getInfo();
    }

    @Override
    public PortletApplicationLifeCycle getManagedPortletApplication() {
        return this.portletApplicationLifeCycle;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.portletContainer.getId() + "]";
    }

    public PortletContainer getPortletContainer() {
        return this.portletContainer;
    }

    @Override
    protected ManagedObjectRegistryEventListener getListener() {
        return this.portletApplicationLifeCycle.getListener();
    }
}

