/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wallet.model.reward.RewardTeam;
import org.exoplatform.wallet.model.reward.RewardTeamMember;
import org.exoplatform.wallet.reward.dao.RewardTeamDAO;
import org.exoplatform.wallet.reward.entity.RewardTeamEntity;
import org.exoplatform.wallet.reward.entity.RewardTeamMemberEntity;

public class WalletRewardTeamStorage {
    private RewardTeamDAO rewardTeamDAO;

    public WalletRewardTeamStorage(RewardTeamDAO rewardTeamDAO) {
        this.rewardTeamDAO = rewardTeamDAO;
    }

    public List<RewardTeam> getTeams() {
        List<RewardTeamEntity> teamEntities = this.rewardTeamDAO.findNotDeletedTeams();
        return teamEntities.stream().map(WalletRewardTeamStorage::toDTO).collect(Collectors.toList());
    }

    public RewardTeam saveTeam(RewardTeam rewardTeam) {
        if (rewardTeam == null) {
            throw new IllegalArgumentException("Empty team to save");
        }
        RewardTeamEntity teamEntity = WalletRewardTeamStorage.fromDTO(rewardTeam);
        teamEntity = teamEntity.getId() == null || teamEntity.getId() == 0L ? (RewardTeamEntity)this.rewardTeamDAO.create(teamEntity) : (RewardTeamEntity)this.rewardTeamDAO.update(teamEntity);
        return WalletRewardTeamStorage.toDTO((RewardTeamEntity)this.rewardTeamDAO.find(teamEntity.getId()));
    }

    public RewardTeam removeTeam(Long teamId) {
        if (teamId == null || teamId == 0L) {
            throw new IllegalArgumentException("Team id is required");
        }
        RewardTeamEntity entity = (RewardTeamEntity)this.rewardTeamDAO.find(teamId);
        if (entity != null) {
            entity.setDeleted(true);
            this.rewardTeamDAO.update(entity);
        }
        return WalletRewardTeamStorage.toDTO(entity);
    }

    public RewardTeam getTeamById(long teamId) {
        if (teamId == 0L) {
            throw new IllegalArgumentException("Team id is required");
        }
        RewardTeamEntity entity = (RewardTeamEntity)this.rewardTeamDAO.find(Long.valueOf(teamId));
        return WalletRewardTeamStorage.toDTO(entity);
    }

    public List<RewardTeam> findTeamsByMemberId(long identityId) {
        List<RewardTeamEntity> entities = this.rewardTeamDAO.findTeamsByMemberId(identityId);
        return entities.stream().map(WalletRewardTeamStorage::toDTO).collect(Collectors.toList());
    }

    public RewardTeam getTeamsById(long teamId) {
        RewardTeamEntity teamEntity = (RewardTeamEntity)this.rewardTeamDAO.find(Long.valueOf(teamId));
        return WalletRewardTeamStorage.toDTO(teamEntity);
    }

    private static RewardTeamEntity fromDTO(RewardTeam rewardTeam) {
        if (rewardTeam == null) {
            return null;
        }
        RewardTeamEntity teamEntity = new RewardTeamEntity();
        teamEntity.setId(rewardTeam.getId() == null || rewardTeam.getId() == 0L ? null : rewardTeam.getId());
        teamEntity.setName(rewardTeam.getName());
        teamEntity.setDescription(rewardTeam.getDescription());
        teamEntity.setBudget(rewardTeam.getBudget());
        teamEntity.setRewardType(rewardTeam.getRewardType());
        teamEntity.setDisabled(rewardTeam.isDisabled());
        teamEntity.setDeleted(rewardTeam.isDeleted());
        if (rewardTeam.getManager() != null && rewardTeam.getManager().getIdentityId() != 0L) {
            teamEntity.setManager(rewardTeam.getManager().getIdentityId());
        }
        if (rewardTeam.getSpaceId() != null && rewardTeam.getSpaceId() != 0L) {
            teamEntity.setSpaceId(rewardTeam.getSpaceId());
        }
        if (rewardTeam.getMembers() != null && !rewardTeam.getMembers().isEmpty()) {
            teamEntity.setMembers(rewardTeam.getMembers().stream().map(rewardTeamMember -> WalletRewardTeamStorage.getRewardTeamMemberEntity(teamEntity, rewardTeamMember)).collect(Collectors.toSet()));
        }
        return teamEntity;
    }

    private static RewardTeam toDTO(RewardTeamEntity teamEntity) {
        SpaceService spaceService;
        Space space;
        if (teamEntity == null) {
            return null;
        }
        RewardTeam rewardTeam = new RewardTeam();
        rewardTeam.setId(teamEntity.getId());
        rewardTeam.setName(teamEntity.getName());
        rewardTeam.setDescription(teamEntity.getDescription());
        rewardTeam.setBudget(teamEntity.getBudget());
        rewardTeam.setManager(WalletRewardTeamStorage.getRewardTeamMember(teamEntity.getManager()));
        rewardTeam.setRewardType(teamEntity.getRewardType());
        rewardTeam.setDisabled(teamEntity.getDisabled().booleanValue());
        rewardTeam.setDeleted(teamEntity.getDeleted().booleanValue());
        if (teamEntity.getSpaceId() != null && teamEntity.getSpaceId() != 0L && (space = (spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class)).getSpaceById(String.valueOf(teamEntity.getSpaceId()))) != null) {
            rewardTeam.setSpaceId(teamEntity.getSpaceId());
            rewardTeam.setSpacePrettyName(space.getPrettyName());
        }
        if (teamEntity.getMembers() != null && !teamEntity.getMembers().isEmpty()) {
            List list = teamEntity.getMembers().stream().map(WalletRewardTeamStorage::getRewardTeamMember).collect(Collectors.toList());
            rewardTeam.setMembers(new ArrayList(list));
        }
        return rewardTeam;
    }

    private static RewardTeamMemberEntity getRewardTeamMemberEntity(RewardTeamEntity teamEntity, RewardTeamMember rewardTeamMember) {
        if (rewardTeamMember == null) {
            return null;
        }
        RewardTeamMemberEntity teamMemberEntity = new RewardTeamMemberEntity();
        teamMemberEntity.setId(rewardTeamMember.getTechnicalId() == null || rewardTeamMember.getTechnicalId() == 0L ? null : rewardTeamMember.getTechnicalId());
        teamMemberEntity.setIdentityId(rewardTeamMember.getIdentityId());
        teamMemberEntity.setTeam(teamEntity);
        return teamMemberEntity;
    }

    private static RewardTeamMember getRewardTeamMember(RewardTeamMemberEntity teamMemberEntity) {
        if (teamMemberEntity == null) {
            return null;
        }
        RewardTeamMember rewardTeamMember = WalletRewardTeamStorage.getRewardTeamMember(teamMemberEntity.getIdentityId());
        if (rewardTeamMember == null) {
            return null;
        }
        rewardTeamMember.setTechnicalId(Long.valueOf(teamMemberEntity.getId()));
        return rewardTeamMember;
    }

    private static RewardTeamMember getRewardTeamMember(Long identityId) {
        if (identityId == null || identityId == 0L) {
            return null;
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getIdentity(String.valueOf(identityId));
        if (identity == null) {
            return null;
        }
        RewardTeamMember rewardTeamMember = new RewardTeamMember();
        rewardTeamMember.setId(identity.getRemoteId());
        rewardTeamMember.setProviderId(identity.getProviderId());
        rewardTeamMember.setIdentityId(Long.valueOf(Long.parseLong(identity.getId())));
        return rewardTeamMember;
    }
}

