/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.filters;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.cms.clouddrives.CloudProvider;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public abstract class AbstractCloudDriveNodeFilter
implements UIExtensionFilter {
    protected static final Log LOG = ExoLogger.getLogger(AbstractCloudDriveNodeFilter.class);
    protected static final String CONTENTVIEWER_REST_PATH = "/contentviewer/";
    public static final String UIJCREXPLORER_CONTEXT_NODE = "UIJCRExplorer.contextNode";
    protected long minSize;
    protected long maxSize;
    protected List<String> providers;

    public AbstractCloudDriveNodeFilter() {
        this(Collections.emptyList());
    }

    public AbstractCloudDriveNodeFilter(List<String> providers) {
        this(providers, 0L, Long.MAX_VALUE);
    }

    public AbstractCloudDriveNodeFilter(long minSize, long maxSize) {
        this(Collections.emptyList(), minSize, maxSize);
    }

    public AbstractCloudDriveNodeFilter(List<String> providers, long minSize, long maxSize) {
        this.providers = providers;
        this.minSize = minSize >= 0L ? minSize : 0L;
        this.maxSize = maxSize;
    }

    public boolean accept(Map<String, Object> context) throws Exception {
        Node contextNode;
        boolean accepted;
        block10: {
            if (context == null) {
                return true;
            }
            accepted = false;
            contextNode = (Node)context.get(Node.class.getName());
            if (contextNode == null) {
                WebuiRequestContext reqContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                contextNode = (Node)reqContext.getAttribute(UIJCREXPLORER_CONTEXT_NODE);
                if (contextNode == null) {
                    contextNode = (Node)reqContext.getAttribute("UIDocumentPreviewNode");
                }
                if (contextNode == null && PortalRequestContext.class.isAssignableFrom(reqContext.getClass())) {
                    try {
                        String[] reqParams;
                        PortalRequestContext portalReqContext = (PortalRequestContext)PortalRequestContext.class.cast(reqContext);
                        String reqPathInfo = portalReqContext.getControllerContext().getRequest().getPathInfo();
                        if (reqPathInfo.startsWith(CONTENTVIEWER_REST_PATH) && (reqParams = reqPathInfo.substring(CONTENTVIEWER_REST_PATH.length()).split("/")).length >= 3) {
                            String repository = reqParams[0];
                            String workspace = reqParams[1];
                            String uuid = reqParams[2];
                            RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
                            SessionProvider sp = WCMCoreUtils.getUserSessionProvider();
                            contextNode = sp.getSession(workspace, repositoryService.getRepository(repository)).getNodeByUUID(uuid);
                        }
                    }
                    catch (AccessDeniedException portalReqContext) {
                    }
                    catch (ItemNotFoundException portalReqContext) {
                    }
                    catch (Throwable e) {
                        if (!LOG.isDebugEnabled()) break block10;
                        LOG.debug((Object)("Cannot find context node in the request: " + e.getMessage()));
                    }
                }
            }
        }
        if (contextNode != null) {
            accepted = this.accept(contextNode);
        }
        return accepted;
    }

    public UIExtensionFilterType getType() {
        return UIExtensionFilterType.MANDATORY;
    }

    public void onDeny(Map<String, Object> context) throws Exception {
    }

    protected boolean acceptProvider(CloudProvider provider) {
        if (this.providers.size() > 0) {
            boolean accepted = this.providers.contains(provider.getId());
            return accepted;
        }
        return true;
    }

    protected abstract boolean accept(Node var1) throws RepositoryException;
}

