/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.core;

import javax.jcr.Node;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.webui.core.UIPermissionFormBase;
import org.exoplatform.ecm.webui.core.UIPermissionInfoBase;
import org.exoplatform.ecm.webui.core.UIUserContainer;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.organization.account.UIUserSelector;

public abstract class UIPermissionManagerBase
extends UIContainer
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UIPermissionManagerBase.class.getName());

    public void initPopupPermission(UIComponent uiSelector) throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById("SelectUserOrGroup");
        if (uiPopup == null) {
            uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "SelectUserOrGroup");
            uiPopup.setWindowSize(560, 345);
            uiPopup.setShowMask(true);
        } else {
            uiPopup.setShowMask(true);
            uiPopup.setRendered(true);
        }
        uiPopup.setUIComponent(uiSelector);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public void initUserSelector() throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById("PopupUserSelector");
        if (uiPopup == null) {
            uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PopupUserSelector");
        }
        uiPopup.setWindowSize(790, 400);
        UIUserContainer uiUserContainer = (UIUserContainer)this.createUIComponent(UIUserContainer.class, null, null);
        uiPopup.setUIComponent((UIComponent)uiUserContainer);
        uiPopup.setShow(true);
        uiPopup.setShowMask(true);
        uiPopup.setResizable(true);
    }

    public void activate() {
        block2: {
            try {
                ((UIPermissionInfoBase)this.getChild(UIPermissionInfoBase.class)).updateGrid(1);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Unexpected error!", new Object[]{e.getMessage()});
            }
        }
    }

    public void checkPermissonInfo(Node node) throws Exception {
        if (node.isLocked()) {
            String lockToken = LockUtil.getLockToken((Node)node);
            if (lockToken != null) {
                node.getSession().addLockToken(lockToken);
            }
            if (!Utils.isLockTokenHolder(node)) {
                ((UIGrid)((UIPermissionInfoBase)this.getChild(UIPermissionInfoBase.class)).getChild(UIGrid.class)).configure("usersOrGroups", UIPermissionInfoBase.PERMISSION_BEAN_FIELD, new String[0]);
                ((UIPermissionFormBase)this.getChild(UIPermissionFormBase.class)).setRendered(false);
            }
        } else if (!PermissionUtil.canChangePermission((Node)node)) {
            ((UIGrid)((UIPermissionInfoBase)this.getChild(UIPermissionInfoBase.class)).getChild(UIGrid.class)).configure("usersOrGroups", UIPermissionInfoBase.PERMISSION_BEAN_FIELD, new String[0]);
            ((UIPermissionFormBase)this.getChild(UIPermissionFormBase.class)).setRendered(false);
        }
    }

    public void deActivate() {
    }

    public static class AddUserActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiForm = (UIUserSelector)event.getSource();
            UIPermissionManagerBase uiParent = (UIPermissionManagerBase)uiForm.getAncestorOfType(UIPermissionManagerBase.class);
            UIPermissionFormBase uiPermissionForm = (UIPermissionFormBase)uiParent.getChild(UIPermissionFormBase.class);
            uiPermissionForm.doSelect("userOrGroup", uiForm.getSelectedUsers());
            UIPopupWindow uiPopup = (UIPopupWindow)uiParent.getChild(UIPopupWindow.class);
            uiPopup.setUIComponent(null);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
        }
    }
}

