/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.util;

import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);

    public static <S, D> void broadcast(ListenerService listenerService, String eventName, S source, D data) {
        try {
            listenerService.broadcast(eventName, source, data);
        }
        catch (Exception e) {
            LOG.error("Error while broadcasting event: {}", new Object[]{eventName, e});
        }
    }

    public static String getStringProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return "";
    }

    public static class NaturalComparator
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            String[] arr1 = s1.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
            String[] arr2 = s2.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
            for (int i = 0; i < arr1.length && i < arr2.length; ++i) {
                if (Character.isDigit(arr1[i].charAt(0)) && Character.isDigit(arr2[i].charAt(0))) {
                    int num2;
                    int num1 = Integer.parseInt(arr1[i]);
                    if (num1 == (num2 = Integer.parseInt(arr2[i]))) continue;
                    return Integer.compare(num1, num2);
                }
                int result = arr1[i].compareToIgnoreCase(arr2[i]);
                if (result == 0) continue;
                return result;
            }
            return s1.compareToIgnoreCase(s2);
        }
    }
}

