/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;

public abstract class ContainerCommand
implements Runnable {
    final String containerName;

    ContainerCommand(String containerName) {
        this.containerName = containerName;
    }

    abstract void execute(ExoContainer var1);

    abstract void onContainerError(String var1);

    @Override
    public void run() {
        ExoContainer exoContainer = ExoContainerContext.getContainerByName((String)this.containerName);
        if (exoContainer != null) {
            ExoContainer contextContainer = ExoContainerContext.getCurrentContainerIfPresent();
            try {
                ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
                RequestLifeCycle.begin((ExoContainer)exoContainer);
                this.execute(exoContainer);
            }
            finally {
                RequestLifeCycle.end();
                ExoContainerContext.setCurrentContainer((ExoContainer)contextContainer);
            }
        } else {
            this.onContainerError("Container not found");
        }
    }
}

