/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.documents.DocumentEditorProvider;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.webui.application.WebuiRequestContext;

public class EditorProvidersHelper {
    protected static final Log LOG = ExoLogger.getLogger(EditorProvidersHelper.class);
    private static EditorProvidersHelper helper;
    private DocumentService documentService;

    private EditorProvidersHelper(DocumentService documentService) {
        this.documentService = documentService;
    }

    public List<ProviderInfo> initExplorer(List<DocumentEditorProvider> providers, Identity identity, String fileId, String workspace, WebuiRequestContext context) {
        return this.initEditorProviders(providers, identity, fileId, workspace, provider -> provider.initExplorer(fileId, workspace, context));
    }

    public List<ProviderInfo> initPreview(List<DocumentEditorProvider> providers, Identity identity, String fileId, String workspace, URI requestUri, Locale locale) {
        return this.initEditorProviders(providers, identity, fileId, workspace, provider -> provider.initPreview(fileId, workspace, requestUri, locale));
    }

    public static EditorProvidersHelper getInstance() {
        if (helper != null) {
            return helper;
        }
        throw new IllegalStateException("EditorProvidersHelper hasn't been initialized yet.");
    }

    protected List<ProviderInfo> initEditorProviders(List<DocumentEditorProvider> providers, Identity identity, String fileId, String workspace, Function<DocumentEditorProvider, Object> initFunction) {
        String preferredProvider = this.getPrefferedEditor(identity.getUserId(), fileId, workspace);
        String currentProvider = this.getCurrentEditor(fileId, workspace);
        List<ProviderInfo> providersInfo = providers.stream().filter(provider -> provider.isAvailableForUser(identity)).map(provider -> {
            try {
                Object editorSettings = initFunction.apply((DocumentEditorProvider)provider);
                boolean preffered = provider.getProviderName().equals(preferredProvider);
                boolean current = provider.getProviderName().equals(currentProvider);
                return new ProviderInfo(provider.getProviderName(), editorSettings, preffered, current);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot init provider " + provider.getProviderName()), (Throwable)e);
                return null;
            }
        }).filter(providerInfo -> providerInfo != null).collect(Collectors.toList());
        return providersInfo;
    }

    protected static void init(DocumentService documentService) {
        if (helper == null) {
            helper = new EditorProvidersHelper(documentService);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"EditorProviderHelper is already initialized");
        }
    }

    protected String getPrefferedEditor(String userId, String fileId, String workspace) {
        String prefferedProvider = null;
        try {
            prefferedProvider = this.documentService.getPreferredEditor(userId, fileId, workspace);
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Cannot get preffered editor for fileId " + fileId), (Throwable)e);
        }
        return prefferedProvider;
    }

    protected String getCurrentEditor(String fileId, String workspace) {
        String currentProvider = null;
        try {
            currentProvider = this.documentService.getCurrentDocumentProvider(fileId, workspace);
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Cannot get current editor for fileId " + fileId), (Throwable)e);
        }
        return currentProvider;
    }

    public static class ProviderInfo {
        private final String provider;
        private final Object settings;
        private final boolean isPreferred;
        private final boolean isCurrent;

        public ProviderInfo(String provider, Object settings, boolean isPreferred, boolean isCurrent) {
            this.provider = provider;
            this.settings = settings;
            this.isPreferred = isPreferred;
            this.isCurrent = isCurrent;
        }

        public String getProvider() {
            return this.provider;
        }

        public Object getSettings() {
            return this.settings;
        }

        public boolean isPreferred() {
            return this.isPreferred;
        }

        public boolean isCurrent() {
            return this.isCurrent;
        }
    }
}

