/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.jcrext.activity;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import org.apache.commons.chain.Context;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class EditFilePropertyActivityAction
implements Action {
    private ListenerService listenerService = WCMCoreUtils.getService(ListenerService.class);
    private ActivityCommonService activityService = WCMCoreUtils.getService(ActivityCommonService.class);

    public boolean execute(Context context) throws Exception {
        Item item = (Item)context.get((Object)"currentItem");
        Node node = item instanceof Property ? item.getParent() : (Node)item;
        String propertyName = item.getName();
        if (!this.activityService.isAcceptedFileProperties(propertyName) || ConversationState.getCurrent() == null) {
            return false;
        }
        if (node.isNodeType("nt:resource")) {
            node = node.getParent();
        }
        if (!node.getPrimaryNodeType().getName().equals("nt:file")) {
            return false;
        }
        if (propertyName.equals("jcr:data")) {
            Node parent;
            SessionProvider systemSessionProvider = WCMCoreUtils.getSystemSessionProvider();
            Session systemSession = systemSessionProvider.getSession(node.getSession().getWorkspace().getName(), WCMCoreUtils.getRepository());
            Node node2 = parent = systemSession.itemExists(node.getPath()) ? ((Node)systemSession.getItem(node.getPath())).getParent() : node.getParent();
            if (parent.hasNode("exo:thumbnails")) {
                Node thumnail = parent.getNode("exo:thumbnails");
                if (thumnail.hasNode(node.getUUID())) {
                    thumnail.getNode(node.getUUID()).remove();
                }
                parent.save();
            }
        }
        if (node.getPrimaryNodeType().getName().equals("nt:file") && this.activityService.isBroadcastNTFileEvents(node) && !this.activityService.isCreating(node)) {
            this.listenerService.broadcast(ActivityCommonService.FILE_EDIT_ACTIVITY, (Object)context, (Object)propertyName);
        }
        return false;
    }
}

