/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.link;

public class LinkBean {
    public static final String SEPARATOR = "@";
    public static final String STATUS = "status=";
    public static final String URL = "url=";
    public static final String STATUS_UNCHECKED = "unchecked";
    public static final String STATUS_ACTIVE = "active";
    public static final String STATUS_BROKEN = "broken";
    private String url;
    private String status;

    public LinkBean(String url, String status) {
        this.url = url;
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return STATUS + this.status + "@url=" + this.url;
    }

    public boolean isBroken() {
        return STATUS_BROKEN.equalsIgnoreCase(this.status);
    }

    public boolean isUnchecked() {
        return STATUS_UNCHECKED.equalsIgnoreCase(this.status);
    }

    public boolean isActive() {
        return STATUS_ACTIVE.equalsIgnoreCase(this.status);
    }

    public static LinkBean parse(String link) {
        if (link == null) {
            return new LinkBean("", "");
        }
        String[] links = link.split(SEPARATOR);
        if (links.length < 2) {
            return new LinkBean("", "");
        }
        String url = links[1].replaceAll(URL, "");
        String status = links[0].replaceAll(STATUS, "");
        return new LinkBean(url, status);
    }
}

