/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.listener;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.model.ProductOrderModification;
import org.exoplatform.perkstore.model.constant.ProductOrderModificationType;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.utils.NotificationUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

@Asynchronous
public class ProductOrderNotificationListener
extends Listener<Product, ProductOrderModification> {
    private ExoContainer container;
    private PerkStoreService perkStoreService;

    public ProductOrderNotificationListener(ExoContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Product, ProductOrderModification> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            ProductOrderModification orderModification = (ProductOrderModification)event.getData();
            ProductOrderModificationType modificationType = orderModification.getModificationType();
            boolean isNew = modificationType == ProductOrderModificationType.NEW;
            NotificationContext ctx = NotificationContextImpl.cloneInstance();
            ctx.append(NotificationUtils.SETTINGS_PARAMETER, (Object)this.getPerkStoreService().getGlobalSettings());
            ctx.append(NotificationUtils.PRODUCT_PARAMETER, event.getSource());
            ctx.append(NotificationUtils.NEW_ORDER_PARAMETER, (Object)orderModification.getNewValue());
            if (orderModification.getOldValue() != null) {
                ctx.append(NotificationUtils.OLD_ORDER_PARAMETER, (Object)orderModification.getOldValue());
            }
            if (orderModification.getLastModifier() != null) {
                ctx.append(NotificationUtils.MODIFIER_PARAMETER, (Object)orderModification.getLastModifier());
            }
            ctx.append(NotificationUtils.ORDER_MODIFICATION_TYPE_PARAMETER, (Object)modificationType);
            ctx.append(NotificationUtils.ORDER_IS_NEW_PARAMETER, (Object)isNew);
            String pluginId = isNew ? "OrderAddedNotificationPlugin" : "OrderModifiedNotificationPlugin";
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)pluginId))).execute(ctx);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private PerkStoreService getPerkStoreService() {
        if (this.perkStoreService == null) {
            this.perkStoreService = (PerkStoreService)this.container.getComponentInstanceOfType(PerkStoreService.class);
        }
        return this.perkStoreService;
    }
}

