/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.File;
import java.io.FileFilter;

public class FilePrefixFilter
implements FileFilter {
    protected final String prefix;
    protected final boolean ignoreCase;

    public FilePrefixFilter(String prefix, boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.prefix = ignoreCase ? prefix.toLowerCase() : prefix;
    }

    public FilePrefixFilter(String prefix) {
        this(prefix, false);
    }

    @Override
    public boolean accept(File file) {
        if (this.ignoreCase) {
            return file.getName().toLowerCase().startsWith(this.prefix);
        }
        return file.getName().startsWith(this.prefix);
    }
}

