/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.util.file.ArchiveBrowser;

public class JarArchiveBrowser
implements Iterator {
    JarFile zip;
    Enumeration entries;
    JarEntry next;
    ArchiveBrowser.Filter filter;

    public JarArchiveBrowser(JarURLConnection url, ArchiveBrowser.Filter filter) {
        this.filter = filter;
        try {
            this.zip = url.getJarFile();
            this.entries = this.zip.entries();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setNext();
    }

    public JarArchiveBrowser(File f, ArchiveBrowser.Filter filter) {
        this.filter = filter;
        try {
            this.zip = new JarFile(f);
            this.entries = this.zip.entries();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private void setNext() {
        this.next = null;
        while (this.entries.hasMoreElements() && this.next == null) {
            do {
                this.next = (JarEntry)this.entries.nextElement();
            } while (this.entries.hasMoreElements() && this.next.isDirectory());
            if (this.next.isDirectory()) {
                this.next = null;
            }
            if (this.next == null || this.filter.accept(this.next.getName())) continue;
            this.next = null;
        }
    }

    public Object next() {
        JarEntry entry = this.next;
        this.setNext();
        try {
            return this.zip.getInputStream(entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Illegal operation on ArchiveBrowser");
    }
}

