/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.clouddrives;

import java.util.Calendar;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.LocalCloudFile;

public class LinkedCloudFile
extends LocalCloudFile {
    private final String id;
    private final String title;
    private final String link;
    private final String editLink;
    private final String previewLink;
    private final String thumbnailLink;
    private final String type;
    private final String typeMode;
    private final String lastUser;
    private final String author;
    private final long size;
    private final transient Calendar createdDate;
    private final transient Calendar modifiedDate;
    private final transient Calendar localModifiedDate;
    private final boolean folder;
    private final String path;
    private final boolean isSymlink;

    public LinkedCloudFile(CloudFile file, String path) {
        Calendar localModifiedDate;
        this.id = file.getId();
        this.title = file.getTitle();
        this.link = file.getLink();
        this.editLink = file.getEditLink();
        this.previewLink = file.getPreviewLink();
        this.thumbnailLink = file.getThumbnailLink();
        this.type = file.getType();
        this.typeMode = file.getTypeMode();
        this.lastUser = file.getLastUser();
        this.author = file.getAuthor();
        this.folder = file.isFolder();
        this.createdDate = file.getCreatedDate();
        this.modifiedDate = file.getModifiedDate();
        this.path = path;
        this.size = file.getSize();
        this.isSymlink = true;
        try {
            localModifiedDate = ((LocalCloudFile)LocalCloudFile.class.cast(file)).getLocalModifiedDate();
        }
        catch (ClassCastException e) {
            localModifiedDate = this.modifiedDate;
        }
        this.localModifiedDate = localModifiedDate;
    }

    public boolean isSymlink() {
        return this.isSymlink;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLink() {
        return this.link;
    }

    public String getEditLink() {
        return this.editLink;
    }

    public String getPreviewLink() {
        return this.previewLink;
    }

    public String getThumbnailLink() {
        return this.thumbnailLink;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeMode() {
        return this.typeMode;
    }

    public String getLastUser() {
        return this.lastUser;
    }

    public String getAuthor() {
        return this.author;
    }

    public Calendar getCreatedDate() {
        return this.createdDate;
    }

    public Calendar getModifiedDate() {
        return this.modifiedDate;
    }

    public boolean isFolder() {
        return this.folder;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public Calendar getLocalModifiedDate() {
        return this.localModifiedDate;
    }
}

