/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.version.VersionHistory;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Path(value="/images/")
public class RESTImagesRendererService
implements ResourceContainer {
    private SessionProviderService sessionProviderService;
    private RepositoryService repositoryService;
    private static final Log LOG = ExoLogger.getLogger((String)RESTImagesRendererService.class.getName());
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static String DEFAULT_MIME_TYPE = "image/jpg";
    private static String PROPERTY_MIME_TYPE = "jcr:mimeType";

    public RESTImagesRendererService(RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{nodeIdentifier}")
    public Response serveImage(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodeIdentifier") String nodeIdentifier, @QueryParam(value="param") @DefaultValue(value="file") String param, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) {
        try {
            SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
            WCMService wcmService = (WCMService)WCMCoreUtils.getService(WCMService.class);
            Node node = wcmService.getReferencedContent(sessionProvider, workspaceName, nodeIdentifier);
            if (node == null) {
                return Response.status((int)404).build();
            }
            if ("file".equals(param)) {
                Node dataNode = null;
                if (WCMCoreUtils.isNodeTypeOrFrozenType((Node)node, (String)"nt:file")) {
                    dataNode = node;
                } else if (node.isNodeType("nt:versionedChild")) {
                    VersionHistory versionHistory = (VersionHistory)node.getProperty("jcr:childVersionHistory").getNode();
                    String versionableUUID = versionHistory.getVersionableUUID();
                    dataNode = sessionProvider.getSession(workspaceName, this.repositoryService.getCurrentRepository()).getNodeByUUID(versionableUUID);
                } else {
                    return Response.status((int)404).build();
                }
                if (ifModifiedSince != null && !this.isModified(ifModifiedSince, dataNode)) {
                    return Response.notModified().build();
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
                Node jcrContentNode = dataNode.getNode("jcr:content");
                String mimeType = DEFAULT_MIME_TYPE;
                if (jcrContentNode.hasProperty(PROPERTY_MIME_TYPE)) {
                    mimeType = jcrContentNode.getProperty(PROPERTY_MIME_TYPE).getString();
                }
                InputStream jcrData = jcrContentNode.getProperty("jcr:data").getStream();
                return Response.ok((Object)jcrData, (String)mimeType).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
            }
            if (ifModifiedSince != null && !this.isModified(ifModifiedSince, node)) {
                return Response.notModified().build();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
            InputStream jcrData = node.getProperty(param).getStream();
            return Response.ok((Object)jcrData, (String)DEFAULT_MIME_TYPE).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        catch (PathNotFoundException e) {
            return Response.status((int)404).build();
        }
        catch (ItemNotFoundException e) {
            return Response.status((int)404).build();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error when serveImage: ", (Throwable)e);
            }
            return Response.serverError().build();
        }
    }

    private Date getLastModifiedDate(Node node) throws Exception {
        Date lastModifiedDate = null;
        if (node.hasNode("jcr:content") && node.getNode("jcr:content").hasProperty("jcr:lastModified")) {
            lastModifiedDate = node.getNode("jcr:content").getProperty("jcr:lastModified").getDate().getTime();
        } else if (node.hasProperty("exo:dateModified")) {
            lastModifiedDate = node.getProperty("exo:dateModified").getDate().getTime();
        } else if (node.hasProperty("jcr:created")) {
            lastModifiedDate = node.getProperty("jcr:created").getDate().getTime();
        }
        return lastModifiedDate;
    }

    private boolean isModified(String ifModifiedSince, Node node) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        if (ifModifiedSince == null || ifModifiedSince.length() == 0) {
            return false;
        }
        try {
            Date ifModifiedSinceDate = dateFormat.parse(ifModifiedSince);
            Date lastModifiedDate = this.getLastModifiedDate(node);
            return lastModifiedDate == null || ifModifiedSinceDate == null || ifModifiedSinceDate.getTime() < lastModifiedDate.getTime();
        }
        catch (ParseException pe) {
            return false;
        }
    }
}

