/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.gatein.wci.security.Credentials;

public abstract class GenericAgent {
    private static Log log = ExoLogger.getLogger(GenericAgent.class);
    public static final String AUTHENTICATED_CREDENTIALS = "authenticatedCredentials";
    private static final String IS_CASE_INSENSITIVE = "exo.auth.case.insensitive";

    public void saveSSOCredentials(String username, HttpServletRequest httpRequest) {
        boolean case_insensitive_bool = true;
        String case_insensitive_str = PropertyManager.getProperty((String)IS_CASE_INSENSITIVE);
        if (case_insensitive_str != null) {
            case_insensitive_bool = Boolean.valueOf(case_insensitive_str);
        }
        if (case_insensitive_bool) {
            username = this.getUserPrincipal(username);
        }
        Credentials credentials = new Credentials(username, "");
        httpRequest.getSession().setAttribute("credentials", (Object)credentials);
        httpRequest.getSession().setAttribute(AUTHENTICATED_CREDENTIALS, (Object)credentials);
        log.debug((Object)("Credentials of user " + username + " saved into HTTP session."));
    }

    public String getUserPrincipal(String username) {
        try {
            OrganizationService organizationService = (OrganizationService)this.getContainer().getComponentInstance(OrganizationService.class);
            Query query = new Query();
            query.setUserName(username);
            ListAccess users = organizationService.getUserHandler().findUsersByQuery(query);
            if (users.getSize() >= 1) {
                String loadedUsername = "";
                User[] listusers = (User[])users.load(0, users.getSize());
                int found = 0;
                for (User user : listusers) {
                    if (!username.equalsIgnoreCase(user.getUserName())) continue;
                    loadedUsername = user.getUserName();
                    ++found;
                }
                if (found == 1 && StringUtils.isNotBlank((String)loadedUsername)) {
                    username = loadedUsername;
                } else {
                    log.warn((Object)("duplicate entry for user " + username));
                }
            }
        }
        catch (Exception exception) {
            log.warn((Object)("Error while retrieving user " + username + " from IDM stores "), (Throwable)exception);
        }
        return username;
    }

    protected final ExoContainer getContainer() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = PortalContainer.getInstance();
        }
        return container;
    }
}

