/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.i18n;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gatein.common.i18n.AbstractLocaleFormat;
import org.gatein.common.text.CharWriter;
import org.gatein.common.util.FormatConversionException;

class RFC3066LanguageTagLocaleFormat
extends AbstractLocaleFormat {
    private static final String RFC3066_SEPARATOR = "-";
    private final Pattern RFC3066_COMPOUND_LANG_PATTERN = Pattern.compile("(\\p{Lower}{2})(-(\\p{Upper}{2}))?");
    private final String[] SORTED_ISO_COUNTRIES = Locale.getISOCountries();
    private final String[] SORTED_ISO_LANGUAGES = Locale.getISOLanguages();

    RFC3066LanguageTagLocaleFormat() {
    }

    @Override
    protected Locale internalGetLocale(String value) throws FormatConversionException {
        Matcher matcher = this.RFC3066_COMPOUND_LANG_PATTERN.matcher(value);
        if (matcher.matches()) {
            String language = matcher.group(1);
            if (Arrays.binarySearch(this.SORTED_ISO_LANGUAGES, language) < 0) {
                throw new FormatConversionException("Invalid ISO language code: " + language);
            }
            String country = matcher.group(3);
            if (country == null) {
                return new Locale(language);
            }
            if (Arrays.binarySearch(this.SORTED_ISO_COUNTRIES, country) < 0) {
                throw new FormatConversionException("Invalid ISO country code: " + country);
            }
            return new Locale(language, country);
        }
        throw new FormatConversionException(value + " is not a valid compound language : accepted " + "format is xx-YY where xx is a valid ISO language code and YY is a valid country code. See " + "java.util.Locale javadoc for more info.");
    }

    @Override
    protected void internalWrite(Locale locale, CharWriter writer) throws IOException {
        String country = locale.getCountry();
        writer.append(locale.getLanguage());
        if (country.length() == 2) {
            writer.append(RFC3066_SEPARATOR);
            writer.append(country);
        } else {
            writer.append(country);
        }
    }
}

