/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mobile.ios;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppleAppSiteAssociationServlet
extends HttpServlet {
    private static final Log LOG = ExoLogger.getExoLogger(AppleAppSiteAssociationServlet.class);
    private static String DEFAULT_IOS_APP_IDS = "FEM998T42U.com.exoplatform.mob.eXoPlatformiPHone,FEM998T42U.org.exoplatform.exo-snapshot,FEM998T42U.org.exoplatform.exo-beta";
    private static String DEFAULT_APP_URLS = "/,/portal/*";

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        JSONObject appleAppSiteAssociationJson = new JSONObject();
        JSONObject webCredentials = new JSONObject();
        JSONObject appLinks = new JSONObject();
        try {
            Object appIds = PropertyManager.getProperty((String)"exo.mobile.ios.appIds");
            appIds = appIds != null ? DEFAULT_IOS_APP_IDS + "," + (String)appIds : DEFAULT_IOS_APP_IDS;
            Object appURLs = PropertyManager.getProperty((String)"exo.mobile.ios.appURLs");
            appURLs = appURLs != null ? DEFAULT_APP_URLS + "," + (String)appURLs : DEFAULT_APP_URLS;
            String[] appIdsArray = new String[]{};
            String[] appURLsArray = new String[]{};
            if (!StringUtils.isBlank((CharSequence)appIds)) {
                appIdsArray = ((String)appIds).split(",");
            }
            if (!StringUtils.isBlank((CharSequence)appURLs)) {
                appURLsArray = ((String)appURLs).split(",");
            }
            webCredentials.put("apps", (Object)appIdsArray);
            JSONArray appsDetails = new JSONArray();
            for (String appId : appIdsArray) {
                JSONObject app = new JSONObject();
                app.put("appId", (Object)appId);
                app.put("paths", (Object)appURLsArray);
                appsDetails.put((Object)app);
            }
            appLinks.put("details", (Object)appsDetails);
            appLinks.put("apps", List.of());
            appleAppSiteAssociationJson.put("appLinks", (Object)appLinks);
            appleAppSiteAssociationJson.put("webcredentials", (Object)webCredentials);
            PrintWriter out = res.getWriter();
            res.setContentType("application/json");
            res.setCharacterEncoding("UTF-8");
            out.print(appleAppSiteAssociationJson);
            out.flush();
        }
        catch (JSONException e) {
            LOG.error((Object)"Problem when creating JSON for Apple Application & site association file !", (Throwable)e);
        }
    }
}

