/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.util;

import java.util.Locale;
import java.util.StringTokenizer;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.StringUtil;
import org.exoplatform.task.util.TaskUtil;

public final class CommentUtil {
    private CommentUtil() {
    }

    public static String formatMention(String text, String lang, UserService userService) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreElements()) {
            User user;
            String username;
            Object next = (String)tokenizer.nextElement();
            if (((String)next).length() == 0) continue;
            if (((String)next).charAt(0) == '@') {
                username = ((String)next).substring(1);
                user = userService.loadUser(username);
                if (user != null && !"guest".equals(user.getUsername())) {
                    next = "<a href=\"" + CommonsUtils.getCurrentDomain() + user.getUrl() + "\">" + encoder.encodeHTML(user.getDisplayName());
                    if (CommentUtil.isExternal(username)) {
                        next = (String)next + "<span class=\" externalTagClass\"> (" + TaskUtil.getResourceBundleLabel(new Locale(lang), "external.label.tag") + ")</span>";
                    }
                    next = (String)next + "</a>";
                }
            } else if (((String)next).startsWith("<p>@")) {
                username = ((String)next).substring(4);
                user = userService.loadUser(username);
                if (user != null && !"guest".equals(user.getUsername())) {
                    next = "<p><a href=\"" + CommonsUtils.getCurrentDomain() + user.getUrl() + "\">" + encoder.encodeHTML(user.getDisplayName());
                    if (CommentUtil.isExternal(username)) {
                        next = (String)next + "<span class=\" externalTagClass\"> (" + TaskUtil.getResourceBundleLabel(new Locale(lang), "external.label.tag") + ")</span>";
                    }
                    next = (String)next + "</a>";
                }
            } else if (((String)next).contains("@") && (user = userService.loadUser(username = ((String)next).split("@")[1])) != null && !"guest".equals(user.getUsername())) {
                next = ((String)next).split("@")[0] + "<a href=\"" + CommonsUtils.getCurrentDomain() + user.getUrl() + "\">" + encoder.encodeHTML(user.getDisplayName());
                if (CommentUtil.isExternal(username)) {
                    next = (String)next + "<span class=\" externalTagClass\"> (" + TaskUtil.getResourceBundleLabel(new Locale(lang), "external.label.tag") + ")</span>";
                }
                next = (String)next + "</a>";
            }
            sb.append((String)next);
            sb.append(' ');
        }
        return StringUtil.encodeInjectedHtmlTag(sb.toString());
    }

    public static boolean isExternal(String userName) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getOrCreateIdentity("organization", userName);
        return identity.getProfile().getProperty("external") != null && identity.getProfile().getProperty("external").equals("true");
    }
}

