/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={UIBaseNodePresentation.OpenDocInDesktopActionListener.class})})
public class UIDocViewer
extends UIBaseNodePresentation {
    private static final String UIDocViewerPopup = "UIDocViewerPopup";
    private static final Log LOG = ExoLogger.getLogger(UIDocViewer.class);
    protected Node originalNode;
    public String docPath;
    public String repository;
    public String workspace;

    public void setOriginalNode(Node originalNode) {
        this.originalNode = originalNode;
    }

    public Node getOriginalNode() throws Exception {
        return this.getDocNode();
    }

    public void setNode(Node node) {
        this.originalNode = node;
    }

    public Node getNode() throws Exception {
        return this.getDocNode();
    }

    public String getTemplate() {
        Node docNode = this.getDocNode();
        if (docNode == null) {
            return null;
        }
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            String nodeType;
            if (docNode.isNodeType("nt:frozenNode")) {
                String uuid = docNode.getProperty("jcr:frozenUuid").getString();
                docNode = docNode.getSession().getNodeByUUID(uuid);
            }
            if (templateService.isManagedNodeType(nodeType = docNode.getPrimaryNodeType().getName())) {
                return templateService.getTemplatePathByUser(false, nodeType, userName);
            }
        }
        catch (RepositoryException re) {
            if (LOG.isDebugEnabled() || LOG.isWarnEnabled()) {
                LOG.error((Object)"Get template catch RepositoryException: ", (Throwable)re);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String getTemplatePath() throws Exception {
        return this.getRepository();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
        return new JCRResourceResolver(workspace);
    }

    public String getNodeType() {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public UIComponent getCommentComponent() {
        return null;
    }

    public UIComponent getRemoveAttach() {
        return null;
    }

    public UIComponent getRemoveComment() {
        return null;
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", mimeType);
        for (UIExtension extension : extensions) {
            UIComponent uiComponent = manager.addUIExtension(extension, context, (UIContainer)this);
            if (uiComponent == null) continue;
            return uiComponent;
        }
        return null;
    }

    public String getRepositoryName() {
        return "repository";
    }

    private Node getDocNode() {
        NodeLocation nodeLocation = new NodeLocation(this.repository, this.workspace, this.docPath);
        return NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
    }

    public UIPopupContainer getPopupContainer() throws Exception {
        UIPopupContainer pContainer1 = (UIPopupContainer)this.getAncestorOfType(UIPopupContainer.class);
        UIPopupContainer pContainer2 = (UIPopupContainer)pContainer1.getChildById(UIDocViewerPopup);
        if (pContainer2 == null) {
            pContainer2 = (UIPopupContainer)pContainer1.addChild(UIPopupContainer.class, null, UIDocViewerPopup);
        }
        return pContainer2;
    }

    public static class DownloadActionListener
    extends EventListener<UIDocViewer> {
        public void execute(Event<UIDocViewer> event) throws Exception {
            UIDocViewer uiComp = (UIDocViewer)((Object)event.getSource());
            String downloadLink = uiComp.getDownloadLink(Utils.getFileLangNode((Node)uiComp.getDocNode()));
            JavascriptManager jsManager = event.getRequestContext().getJavascriptManager();
            downloadLink = downloadLink.replaceAll("&amp;", "&");
            jsManager.addJavascript((CharSequence)("window.location.href = " + downloadLink + ";"));
        }
    }
}

