/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space.customization.listeners;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.space.customization.SpaceCustomizationService;
import org.exoplatform.social.space.customization.listeners.CustomizeSpaceDriveListener;

public class CustomizeSpaceFolderListener
extends SpaceListenerPlugin {
    private SpaceCustomizationService spaceCustomizationService;
    private static final Log LOG = ExoLogger.getExoLogger(CustomizeSpaceDriveListener.class);

    public CustomizeSpaceFolderListener(SpaceCustomizationService spaceCustomizationService) {
        this.spaceCustomizationService = spaceCustomizationService;
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        String groupId = event.getSpace().getGroupId();
        try {
            this.spaceCustomizationService.createSpaceDefaultFolders(groupId);
        }
        catch (Exception e) {
            LOG.error((Object)("Can not create default folder for space : " + groupId), (Throwable)e);
        }
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
    }
}

