/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.web.security.sso.SSOHelper;

public class JSFAjaxRedirectFilter
extends AbstractFilter {
    private static final String DO_LOGIN_PATTERN = "login";
    private static final String START_AJAX_REDIRECT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><partial-response><redirect url=\"";
    private static String END_AJAX_REDIRECT = "\"/></partial-response>";
    private static final String AJAX_JSF_HTTP_HEADER = "Faces-Request";
    private static final String AJAX_JSF_HTTP_HEADER_VALUE = "partial/ajax";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (req.getRemoteUser() == null && this.isJSFAjaxRequest(req)) {
            String loginPath = this.buildLoginPath(req);
            this.writeJSFAjaxRedirect(res, loginPath);
            return;
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    public void destroy() {
    }

    private String buildLoginPath(HttpServletRequest request) throws UnsupportedEncodingException {
        StringBuilder initialURI = new StringBuilder();
        initialURI.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            initialURI.append("?").append(request.getQueryString());
        }
        StringBuilder loginPath = new StringBuilder();
        SSOHelper ssoHelper = (SSOHelper)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SSOHelper.class);
        if (ssoHelper != null && ssoHelper.isSSOEnabled()) {
            loginPath.append(request.getContextPath()).append(ssoHelper.getSSORedirectURLSuffix());
        } else {
            loginPath.append(request.getContextPath()).append("/").append(DO_LOGIN_PATTERN);
        }
        loginPath.append("?initialURI=").append(URLEncoder.encode(initialURI.toString(), "UTF-8"));
        return loginPath.toString();
    }

    private void writeJSFAjaxRedirect(HttpServletResponse response, String pUrl) throws IOException {
        String[] splitedUrl = pUrl.split("\\?initialURI=");
        String requestURI = splitedUrl[0];
        Object finalUrl = requestURI;
        if (splitedUrl.length > 1) {
            finalUrl = (String)finalUrl + "?initialURI=" + URLDecoder.decode(splitedUrl[1], "UTF-8").split("\\?")[0];
        }
        try {
            response.reset();
            response.addHeader("Content-Type", "text/xml;charset=UTF-8");
            response.getWriter().append(START_AJAX_REDIRECT);
            response.getWriter().append((CharSequence)finalUrl);
            response.getWriter().append(END_AJAX_REDIRECT);
            response.getWriter().flush();
        }
        catch (Exception e) {
            throw new IOException("Sending Ajax redirect in error.", e);
        }
    }

    private boolean isJSFAjaxRequest(HttpServletRequest req) {
        String headerValue = req.getHeader(AJAX_JSF_HTTP_HEADER);
        return headerValue != null && AJAX_JSF_HTTP_HEADER_VALUE.contentEquals(headerValue);
    }
}

