/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import java.util.Collections;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.container.UIContainerActionListener;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/portal/webui/container/UISimpleColumnContainer.gtmpl", events={@EventConfig(listeners={InsertColumnActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.DeleteComponentActionListener.class}, confirm="UIColumnContainer.deleteColumnContainer"), @EventConfig(listeners={UIContainerActionListener.EditContainerActionListener.class})})
public class UISimpleColumnContainer
extends UIContainer {
    public static final String SIMPLE_COLUMN_CONTAINER = "SimpleColumnContainer";
    public static final String INSERT_AFTER = "insertColumnAfter";
    public static final String INSERT_BEFORE = "insertColumnBefore";

    private static void insertColumn(UISimpleColumnContainer selectedColumn, boolean isInsertAfter) throws Exception {
        UIContainer uiParent = (UIContainer)selectedColumn.getParent();
        UISimpleColumnContainer uiNewColumn = (UISimpleColumnContainer)uiParent.addChild(UISimpleColumnContainer.class, null, null);
        uiNewColumn.setTemplate(selectedColumn.getTemplate());
        uiNewColumn.setFactoryId(selectedColumn.getFactoryId());
        uiNewColumn.setId(String.valueOf(Math.abs(((Object)((Object)uiNewColumn)).hashCode())));
        uiNewColumn.setMoveAppsPermissions(uiNewColumn.getAccessPermissions());
        uiNewColumn.setMoveContainersPermissions(uiNewColumn.getAccessPermissions());
        List listColumn = uiParent.getChildren();
        int position = listColumn.indexOf((Object)selectedColumn);
        if (isInsertAfter) {
            ++position;
        }
        Collections.rotate(listColumn.subList(position, listColumn.size()), 1);
    }

    public static class InsertColumnActionListener
    extends EventListener<UISimpleColumnContainer> {
        public void execute(Event<UISimpleColumnContainer> event) throws Exception {
            String insertPosition = event.getRequestContext().getRequestParameter("objectId");
            UISimpleColumnContainer uiSelectedColumn = (UISimpleColumnContainer)((Object)event.getSource());
            UIPortalComponent uiParent = (UIPortalComponent)uiSelectedColumn.getParent();
            if (insertPosition.equals(UISimpleColumnContainer.INSERT_AFTER)) {
                UISimpleColumnContainer.insertColumn(uiSelectedColumn, true);
            } else if (insertPosition.equals(UISimpleColumnContainer.INSERT_BEFORE)) {
                UISimpleColumnContainer.insertColumn(uiSelectedColumn, false);
            }
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiParent);
            pcontext.ignoreAJAXUpdateOnPortlets(true);
            pcontext.getJavascriptManager().require("SHARED/portalComposer", "portalComposer").addScripts("portalComposer.toggleSaveButton();");
        }
    }
}

