/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Arrays;

public class AsciiString
implements Comparable<AsciiString> {
    protected final byte[] val;

    public AsciiString() {
        this.val = new byte[0];
    }

    public AsciiString(String str) {
        int length = str != null ? str.length() : 0;
        this.val = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.val[i] = (byte)str.charAt(i);
        }
    }

    public AsciiString(AsciiString str) {
        this.val = str.val;
    }

    public AsciiString(byte[] val) {
        this.val = val;
    }

    public AsciiString(int length) {
        this.val = new byte[length];
    }

    public byte[] chars() {
        return this.val;
    }

    public int length() {
        return this.val.length;
    }

    @Override
    public int compareTo(AsciiString str) {
        if (str == null) {
            return 1;
        }
        if (this.chars().hashCode() == str.val.hashCode()) {
            return 0;
        }
        int len1 = this.val.length;
        int len2 = str.val.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte c1 = this.val[k];
            byte c2 = str.val[k];
            if (c1 == c2) continue;
            return c1 > c2 ? 1 : -1;
        }
        return len1 > len2 ? 1 : (len1 < len2 ? -1 : 0);
    }

    public boolean equals(Object obj) {
        return obj instanceof AsciiString && this.equals(((AsciiString)obj).val);
    }

    public boolean equals(byte[] other) {
        return Arrays.equals(this.val, other);
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.val.length; ++i) {
            h = 31 * h + this.val[i];
        }
        return h;
    }

    public String toString() {
        return new String(this.val);
    }
}

