/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;

public class I18N {
    public static String toJavaIdentifier(Locale locale) throws NullPointerException {
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        return locale.toString();
    }

    public static Locale parseJavaIdentifier(String s) throws NullPointerException, IllegalArgumentException {
        return LocaleUtils.toLocale((String)s);
    }

    public static String toTagIdentifier(Locale locale) throws NullPointerException {
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        String country = locale.getCountry();
        String lang = locale.getLanguage();
        if (country != null && country.length() > 0) {
            return lang + "-" + country;
        }
        return lang;
    }

    public static Locale parseTagIdentifier(String s) throws NullPointerException, IllegalArgumentException {
        if (s == null) {
            throw new NullPointerException("No null string accepted");
        }
        if (s.length() == 2 || s.length() == 3) {
            return new Locale(s);
        }
        if (s.length() == 5 && s.charAt(2) == '-') {
            String lang = s.substring(0, 2);
            String country = s.substring(3, 5);
            return new Locale(lang, country);
        }
        if (s.length() == 6 && s.charAt(3) == '-') {
            String lang = s.substring(0, 3);
            String country = s.substring(4, 6);
            return new Locale(lang, country);
        }
        throw new IllegalArgumentException("Locale " + s + " cannot be parsed");
    }

    public static Locale getParent(Locale locale) throws NullPointerException {
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        if (locale.getVariant() != null && locale.getVariant().length() > 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry() != null && locale.getCountry().length() > 0) {
            return new Locale(locale.getLanguage());
        }
        return null;
    }
}

