/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.apache.sis.internal.system.ReferenceQueueConsumer;
import org.apache.sis.referencing.factory.sql.AuthorityCodes;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.logging.Logging;

final class CloseableReference
extends WeakReference<AuthorityCodes>
implements Disposable {
    private final EPSGDataAccess factory;
    private final Statement[] statements;

    CloseableReference(AuthorityCodes authorityCodes, EPSGDataAccess ePSGDataAccess, Statement[] statementArray) {
        super(authorityCodes, ReferenceQueueConsumer.QUEUE);
        this.statements = statementArray;
        this.factory = ePSGDataAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() throws SQLException {
        SQLException sQLException = null;
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            int n = this.statements.length;
            while (--n >= 0) {
                Statement statement = this.statements[n];
                this.statements[n] = null;
                if (statement == null) continue;
                try {
                    statement.close();
                }
                catch (SQLException sQLException2) {
                    if (sQLException == null) {
                        sQLException = sQLException2;
                        continue;
                    }
                    sQLException.addSuppressed(sQLException2);
                }
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.referencing.factory"), AuthorityCodes.class, (String)"close", (Throwable)sQLException);
        }
    }
}

