/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBTableManager;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.database.annotation.Table;
import org.exoplatform.services.database.annotation.TableField;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class StandardSQLTableManager
extends DBTableManager {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.database.StandardSQLTableManager");
    private ExoDatasource exoDatasource;

    public StandardSQLTableManager(ExoDatasource datasource) {
        this.exoDatasource = datasource;
    }

    @Override
    public <T extends DBObject> void createTable(Class<T> type, boolean dropIfExist) throws Exception {
        Table table = type.getAnnotation(Table.class);
        if (table == null) {
            throw new Exception("Cannot find the annotation for class " + type.getClass().getName());
        }
        StringBuilder builder = new StringBuilder(1000);
        builder.append("CREATE TABLE ").append(table.name()).append(" (");
        this.appendId(builder);
        TableField[] fields = table.field();
        for (int i = 0; i < fields.length; ++i) {
            TableField field = fields[i];
            String fieldType = field.type();
            if ("string".equals(fieldType)) {
                this.appendStringField(field, builder);
            } else if ("int".equals(fieldType)) {
                this.appendIntegerField(field, builder);
            } else if ("long".equals(fieldType)) {
                this.appendLongField(field, builder);
            } else if ("float".equals(fieldType)) {
                this.appendFloatField(field, builder);
            } else if ("double".equals(fieldType)) {
                this.appendDoubleField(field, builder);
            } else if ("boolean".equals(fieldType)) {
                this.appendBooleanField(field, builder);
            } else if ("date".equals(fieldType)) {
                this.appendDateField(field, builder);
            } else if ("binary".equals(fieldType)) {
                this.appendBinaryField(field, builder);
            }
            if (i == fields.length - 1) continue;
            builder.append(", ");
        }
        builder.append(")");
        Connection conn = this.exoDatasource.getConnection();
        conn.setAutoCommit(false);
        Statement statement = conn.createStatement();
        LOG.debug((Object)("QUERY: \n  " + builder + "\n"));
        if (dropIfExist && this.hasTable(type)) {
            statement.execute("DROP TABLE IF EXISTS " + table.name());
        }
        statement.execute(builder.toString());
        statement.close();
        conn.commit();
        this.exoDatasource.closeConnection(conn);
    }

    @Override
    public <T extends DBObject> void dropTable(Class<T> type) throws Exception {
        Table table = type.getAnnotation(Table.class);
        if (table == null) {
            throw new Exception("Can not find the annotation for class " + type.getClass().getName());
        }
        Connection conn = this.exoDatasource.getConnection();
        Statement s = conn.createStatement();
        s.execute("DROP TABLE " + table.name());
        s.close();
        conn.commit();
        this.exoDatasource.closeConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DBObject> boolean hasTable(Class<T> type) throws Exception {
        Table table = type.getAnnotation(Table.class);
        if (table == null) {
            throw new Exception("Can not find the annotation for class " + type.getClass().getName());
        }
        Connection connection = this.exoDatasource.getConnection();
        Statement statement = connection.createStatement();
        try {
            if (statement.execute("SELECT 1 FROM " + table.name())) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            statement.close();
            this.exoDatasource.closeConnection(connection);
        }
        return false;
    }

    protected void appendId(StringBuilder builder) {
        builder.append("ID BIGINT NOT NULL PRIMARY KEY, ");
    }

    protected void appendStringField(TableField field, StringBuilder builder) throws Exception {
        if (field.length() < 1) {
            throw new Exception("You forget to specify  the length for field " + field.name() + " , type " + field.type());
        }
        builder.append(field.name()).append(" ").append("VARCHAR(" + field.length() + ")");
        if (!field.nullable()) {
            builder.append(" NOT NULL ");
        }
    }

    protected void appendIntegerField(TableField field, StringBuilder builder) {
        builder.append(field.name()).append(" INTEGER");
    }

    protected void appendLongField(TableField field, StringBuilder builder) {
        builder.append(field.name()).append(" BIGINT");
    }

    protected void appendFloatField(TableField field, StringBuilder builder) {
        builder.append(field.name()).append(" REAL");
    }

    protected void appendDoubleField(TableField field, StringBuilder builder) {
        builder.append(field.name()).append(" DOUBLE");
    }

    protected void appendBooleanField(TableField field, StringBuilder builder) {
        builder.append(field.name()).append(" BIT");
    }

    protected void appendDateField(TableField field, StringBuilder builder) {
        builder.append(field.name()).append(" DATE");
    }

    protected void appendDateTimeField(TableField field, StringBuilder builder) {
        builder.append(field.name()).append(" DATETIME");
    }

    protected void appendBinaryField(TableField field, StringBuilder builder) {
        builder.append(field.name()).append(" VARBINARY");
    }
}

