/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.gatein.common.util.CollectionMap;

public class SetMap<K, V>
extends CollectionMap<K, V> {
    static final long serialVersionUID = -7239767000556095977L;

    public SetMap() {
    }

    public SetMap(SetMap<K, V> other) throws IllegalArgumentException {
        super(other);
    }

    public SetMap(SetMap<K, V> other, Comparator<V> comparator) throws IllegalArgumentException {
        super(other);
        if (comparator == null) {
            throw new IllegalArgumentException("No null comparator allowed");
        }
        this.comparator = comparator;
    }

    public SetMap(Comparator<V> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("No null comparator allowed");
        }
        this.comparator = comparator;
    }

    @Override
    public Set<V> get(K key) {
        return (Set)super.get(key);
    }

    @Override
    protected void add(Collection<V> c, V o) {
        c.add(o);
    }

    @Override
    protected void remove(Collection<V> c, Object o) {
        c.remove(o);
    }

    @Override
    protected Collection<V> newCollection() {
        if (this.comparator == null) {
            return new HashSet();
        }
        return new TreeSet(this.comparator);
    }

    @Override
    protected Collection<V> newCollection(Collection<V> other) {
        if (this.comparator == null) {
            return new HashSet<V>(other);
        }
        TreeSet<V> set = new TreeSet<V>(this.comparator);
        set.addAll(other);
        return set;
    }
}

