/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.facebook;

import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.web.security.security.SecureRandomService;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.facebook.FacebookAccessTokenContext;
import org.gatein.security.oauth.facebook.GateInFacebookProcessor;
import org.gatein.security.oauth.social.FacebookPrincipal;
import org.gatein.security.oauth.social.FacebookProcessor;
import org.gatein.security.oauth.spi.InteractionState;
import org.gatein.security.oauth.spi.OAuthCodec;
import org.gatein.security.oauth.utils.OAuthPersistenceUtils;

public class GateInFacebookProcessorImpl
implements GateInFacebookProcessor {
    private static Log log = ExoLogger.getLogger(GateInFacebookProcessorImpl.class);
    private final String clientId;
    private final String clientSecret;
    private final String scope;
    private final String redirectURL;
    private final FacebookProcessor facebookProcessor;
    private final SecureRandomService secureRandomService;
    private final int chunkLength;

    public GateInFacebookProcessorImpl(ExoContainerContext context, InitParams params, SecureRandomService secureRandomService) {
        this.clientId = params.getValueParam("clientId").getValue();
        this.clientSecret = params.getValueParam("clientSecret").getValue();
        String scope = params.getValueParam("scope").getValue();
        String redirectURL = params.getValueParam("redirectURL").getValue();
        if (this.clientId == null || this.clientId.length() == 0 || this.clientId.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientId' needs to be provided. The value should be clientId of your Facebook application");
        }
        if (this.clientSecret == null || this.clientSecret.length() == 0 || this.clientSecret.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientSecret' needs to be provided. The value should be clientSecret of your Facebook application");
        }
        this.scope = scope == null ? "email" : scope;
        this.redirectURL = redirectURL == null || redirectURL.length() == 0 ? "http://localhost:8080/" + context.getName() + "/facebookAuth" : redirectURL.replaceAll("@@portal.container.name@@", context.getName());
        this.chunkLength = OAuthPersistenceUtils.getChunkLength(params);
        if (log.isDebugEnabled()) {
            log.debug((Object)("configuration: clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", scope=" + this.scope + ", redirectURL=" + this.redirectURL + ", chunkLength=" + this.chunkLength));
        }
        this.facebookProcessor = new FacebookProcessor(this.clientId, this.clientSecret, this.scope, this.redirectURL);
        this.secureRandomService = secureRandomService;
    }

    @Override
    public InteractionState<FacebookAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String scope) throws IOException {
        return this.processOAuthInteractionImpl(httpRequest, httpResponse, new FacebookProcessor(this.clientId, this.clientSecret, scope, this.redirectURL));
    }

    @Override
    public InteractionState<FacebookAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        return this.processOAuthInteractionImpl(httpRequest, httpResponse, this.facebookProcessor);
    }

    protected InteractionState<FacebookAccessTokenContext> processOAuthInteractionImpl(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FacebookProcessor facebookProcessor) throws IOException {
        HttpSession session = httpRequest.getSession();
        String state = (String)session.getAttribute("_authState");
        if (log.isTraceEnabled()) {
            log.trace((Object)("state=" + state));
        }
        if (state == null || state.isEmpty()) {
            String verificationState = String.valueOf(this.secureRandomService.getSecureRandom().nextLong());
            facebookProcessor.initialInteraction(httpRequest, httpResponse, verificationState);
            state = InteractionState.State.AUTH.name();
            session.setAttribute("_authState", (Object)state);
            session.setAttribute("_verificationState", (Object)verificationState);
            return new InteractionState<Object>(InteractionState.State.valueOf(state), null);
        }
        if (state.equals(InteractionState.State.AUTH.name())) {
            String accessToken = facebookProcessor.getAccessToken(httpRequest, httpResponse);
            if (accessToken == null) {
                throw new OAuthException(OAuthExceptionCode.FACEBOOK_ERROR, "AccessToken was null");
            }
            Set<String> scopes = facebookProcessor.getScopes(accessToken);
            state = InteractionState.State.FINISH.name();
            session.removeAttribute("_authState");
            session.removeAttribute("_verificationState");
            FacebookAccessTokenContext accessTokenContext = new FacebookAccessTokenContext(accessToken, scopes);
            return new InteractionState<FacebookAccessTokenContext>(InteractionState.State.valueOf(state), accessTokenContext);
        }
        return new InteractionState<Object>(InteractionState.State.valueOf(state), null);
    }

    @Override
    public FacebookPrincipal getPrincipal(FacebookAccessTokenContext accessTokenContext) {
        String accessToken = accessTokenContext.getAccessToken();
        return this.facebookProcessor.getPrincipal(accessToken);
    }

    @Override
    public String getAvatar(FacebookAccessTokenContext accessTokenContext) {
        String accessToken = accessTokenContext.getAccessToken();
        return this.facebookProcessor.getUserAvatarURL(accessToken);
    }

    @Override
    public void saveAccessTokenAttributesToUserProfile(UserProfile userProfile, OAuthCodec codec, FacebookAccessTokenContext accessTokenContext) {
        String realAccessToken = accessTokenContext.getAccessToken();
        String encodedAccessToken = codec.encodeString(realAccessToken);
        OAuthPersistenceUtils.saveLongAttribute(encodedAccessToken, userProfile, "user.social-info.facebook.accessToken", true, this.chunkLength);
        userProfile.setAttribute("user.social-info.facebook.scope", accessTokenContext.getScopesAsString());
    }

    @Override
    public FacebookAccessTokenContext getAccessTokenFromUserProfile(UserProfile userProfile, OAuthCodec codec) {
        String encodedAccessToken = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.facebook.accessToken", true);
        if (encodedAccessToken == null) {
            return null;
        }
        String accessToken = codec.decodeString(encodedAccessToken);
        String scopesAsString = userProfile.getAttribute("user.social-info.facebook.scope");
        return new FacebookAccessTokenContext(accessToken, scopesAsString);
    }

    @Override
    public void removeAccessTokenFromUserProfile(UserProfile userProfile) {
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.facebook.accessToken", true);
    }

    @Override
    public void revokeToken(FacebookAccessTokenContext accessToken) {
        String realAccessToken = accessToken.getAccessToken();
        this.facebookProcessor.revokeToken(realAccessToken);
    }

    @Override
    public FacebookAccessTokenContext validateTokenAndUpdateScopes(FacebookAccessTokenContext accessToken) throws OAuthException {
        Set<String> scopes = this.facebookProcessor.getScopes(accessToken.getAccessToken());
        return new FacebookAccessTokenContext(accessToken.getAccessToken(), scopes);
    }

    @Override
    public <C> C getAuthorizedSocialApiObject(FacebookAccessTokenContext accessToken, Class<C> socialApiObjectType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Class '" + socialApiObjectType + "' not supported by this processor"));
        }
        return null;
    }
}

