/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpResponseException;
import java.io.IOException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.google.GoogleAccessTokenContext;
import org.gatein.security.oauth.google.GoogleProcessor;

abstract class GoogleRequest<T> {
    private static Log log = ExoLogger.getLogger(GoogleRequest.class);

    GoogleRequest() {
    }

    protected abstract T invokeRequest(GoogleAccessTokenContext var1) throws IOException;

    protected abstract OAuthException createException(IOException var1);

    public T executeRequest(GoogleAccessTokenContext accessTokenContext, GoogleProcessor googleProcessor) {
        GoogleTokenResponse tokenData = accessTokenContext.getTokenData();
        try {
            return this.invokeRequest(accessTokenContext);
        }
        catch (IOException ioe) {
            HttpResponseException googleException;
            if (ioe instanceof HttpResponseException && (googleException = (HttpResponseException)ioe).getStatusCode() == 400 && tokenData.getRefreshToken() != null) {
                try {
                    googleProcessor.refreshToken(accessTokenContext);
                    return this.invokeRequest(accessTokenContext);
                }
                catch (OAuthException refreshException) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Refreshing token failed", (Throwable)refreshException);
                    }
                }
                catch (IOException ioe2) {
                    ioe = ioe2;
                }
            }
            log.warn((Object)("Error when calling Google operation. Details: " + ioe.getMessage()));
            throw this.createException(ioe);
        }
    }
}

