/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.lib.LongLookup;

public class DoubleIntIndex
implements IntLookup,
LongLookup {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private boolean sortOnValues = true;
    private boolean hasChanged;
    private final boolean fixedSize;
    private int[] keys;
    private int[] values;
    private int targetSearchValue;

    public DoubleIntIndex(int n, boolean bl) {
        this.capacity = n;
        this.keys = new int[n];
        this.values = new int[n];
        this.fixedSize = bl;
        this.hasChanged = true;
    }

    public synchronized int getKey(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[n];
    }

    public synchronized int getValue(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[n];
    }

    public synchronized void setKey(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.keys[n] = n2;
    }

    public synchronized void setValue(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.values[n] = n2;
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.capacity;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int[] getValues() {
        return this.values;
    }

    public long getTotalValues() {
        long l = 0L;
        for (int i = 0; i < this.count; ++i) {
            l += (long)this.values[i];
        }
        return l;
    }

    public void setSize(int n) {
        this.count = n;
    }

    @Override
    public synchronized boolean addUnsorted(long l, long l2) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.addUnsorted((int)l, (int)l2);
    }

    @Override
    public synchronized boolean addUnsorted(int n, int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0) {
            if (this.sortOnValues) {
                if (n2 < this.values[this.count - 1]) {
                    this.sorted = false;
                }
            } else if (n < this.keys[this.count - 1]) {
                this.sorted = false;
            }
        }
        this.hasChanged = true;
        this.keys[this.count] = n;
        this.values[this.count] = n2;
        ++this.count;
        return true;
    }

    public synchronized boolean addUnsorted(DoubleIntIndex doubleIntIndex) {
        if (this.count + doubleIntIndex.count > this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            while (this.count + doubleIntIndex.count > this.capacity) {
                this.doubleCapacity();
            }
        }
        this.sorted = false;
        this.hasChanged = true;
        for (int i = 0; i < doubleIntIndex.count; ++i) {
            this.keys[this.count] = doubleIntIndex.keys[i];
            this.values[this.count] = doubleIntIndex.values[i];
            ++this.count;
        }
        return true;
    }

    public synchronized boolean addSorted(int n, int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.count != 0) {
            if (this.sortOnValues) {
                if (n2 < this.values[this.count - 1]) {
                    return false;
                }
                if (n2 == this.values[this.count - 1] && n < this.keys[this.count - 1]) {
                    return false;
                }
            } else if (n < this.keys[this.count - 1]) {
                return false;
            }
        }
        this.hasChanged = true;
        this.keys[this.count] = n;
        this.values[this.count] = n2;
        ++this.count;
        return true;
    }

    public synchronized boolean addUnique(int n, int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? n2 : n;
        int n3 = this.binaryEmptySlotSearch();
        if (n3 == -1) {
            return false;
        }
        this.hasChanged = true;
        if (this.count != n3) {
            this.moveRows(n3, n3 + 1, this.count - n3);
        }
        this.keys[n3] = n;
        this.values[n3] = n2;
        ++this.count;
        return true;
    }

    @Override
    public int add(long l, long l2) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.add((int)l, (int)l2);
    }

    @Override
    public synchronized int add(int n, int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return -1;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? n2 : n;
        int n3 = this.binarySlotSearch(true);
        this.hasChanged = true;
        if (this.count != n3) {
            this.moveRows(n3, n3 + 1, this.count - n3);
        }
        this.keys[n3] = n;
        this.values[n3] = n2;
        ++this.count;
        return n3;
    }

    @Override
    public long lookup(long l) throws NoSuchElementException {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new NoSuchElementException();
        }
        return this.lookup((int)l);
    }

    @Override
    public int lookup(int n) throws NoSuchElementException {
        int n2;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n2 = this.findFirstEqualKeyIndex(n)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(n2);
    }

    @Override
    public long lookup(long l, long l2) {
        int n;
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            return l2;
        }
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n = this.findFirstEqualKeyIndex((int)l)) == -1) {
            return l2;
        }
        return this.getValue(n);
    }

    @Override
    public int lookup(int n, int n2) {
        int n3;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n3 = this.findFirstEqualKeyIndex(n)) == -1) {
            return n2;
        }
        return this.getValue(n3);
    }

    @Override
    public void clear() {
        this.removeAll();
    }

    public int lookupFirstGreaterEqual(int n) throws NoSuchElementException {
        int n2;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n2 = this.findFirstGreaterEqualKeyIndex(n)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(n2);
    }

    public synchronized void setValuesSearchTarget() {
        if (!this.sortOnValues && this.count > 1) {
            this.sorted = false;
        }
        this.sortOnValues = true;
    }

    public synchronized void setKeysSearchTarget() {
        if (this.sortOnValues && this.count > 1) {
            this.sorted = false;
        }
        this.sortOnValues = false;
    }

    public synchronized int findFirstGreaterEqualKeyIndex(int n) {
        int n2 = this.findFirstGreaterEqualSlotIndex(n);
        return n2 == this.count ? -1 : n2;
    }

    public synchronized int findFirstEqualKeyIndex(int n) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        return this.binaryFirstSearch();
    }

    public synchronized boolean compactLookupAsIntervals() {
        int n;
        if (this.size() == 0) {
            return false;
        }
        this.setKeysSearchTarget();
        if (!this.sorted) {
            this.fastQuickSort();
        }
        int n2 = 0;
        for (n = 1; n < this.count; ++n) {
            long l = this.keys[n2] + this.values[n2];
            if (l == (long)this.keys[n]) {
                int n3 = n2;
                this.values[n3] = this.values[n3] + this.values[n];
                continue;
            }
            this.keys[++n2] = this.keys[n];
            this.values[n2] = this.values[n];
        }
        for (n = n2 + 1; n < this.count; ++n) {
            this.keys[n] = 0;
            this.values[n] = 0;
        }
        if (this.count != n2 + 1) {
            this.setSize(n2 + 1);
            return true;
        }
        return false;
    }

    public synchronized int findFirstGreaterEqualSlotIndex(int n) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        return this.binarySlotSearch(false);
    }

    private int binaryFirstSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.count;
        while (n < n2) {
            n3 = n + n2 >>> 1;
            n4 = this.compare(n3);
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
            n5 = n3;
        }
        return n5 == this.count ? -1 : n5;
    }

    private int binarySlotSearch(boolean bl) {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            n3 = n + n2 >>> 1;
            n4 = this.compare(n3);
            if (n4 <= 0) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        return n;
    }

    private int binaryEmptySlotSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            n3 = n + n2 >>> 1;
            n4 = this.compare(n3);
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return -1;
        }
        return n;
    }

    public synchronized void sort() {
        this.fastQuickSort();
    }

    private synchronized void fastQuickSort() {
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(32, false);
        int n = 16;
        doubleIntIndex.push(0, this.count - 1);
        while (doubleIntIndex.size() > 0) {
            int n2 = doubleIntIndex.peekKey();
            int n3 = doubleIntIndex.peekValue();
            doubleIntIndex.pop();
            if (n3 - n2 >= n) {
                int n4 = this.partition(n2, n3, n2 + (n3 - n2 >>> 1));
                doubleIntIndex.push(n2, n4 - 1);
                doubleIntIndex.push(n4 + 1, n3);
                continue;
            }
            this.insertionSort(n2, n3);
        }
        this.sorted = true;
    }

    private int partition(int n, int n2, int n3) {
        int n4 = n;
        this.swap(n3, n2);
        for (int i = n; i <= n2 - 1; ++i) {
            if (!this.lessThan(i, n2)) continue;
            this.swap(i, n4);
            ++n4;
        }
        this.swap(n4, n2);
        return n4;
    }

    private synchronized void fastQuickSortRecursive() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int n, int n2) {
        int n3 = 16;
        if (n2 - n > n3) {
            int n4 = (n2 + n) / 2;
            if (this.lessThan(n4, n)) {
                this.swap(n, n4);
            }
            if (this.lessThan(n2, n)) {
                this.swap(n, n2);
            }
            if (this.lessThan(n2, n4)) {
                this.swap(n4, n2);
            }
            int n5 = n2 - 1;
            this.swap(n4, n5);
            n4 = n;
            int n6 = n5;
            while (true) {
                if (this.lessThan(++n4, n6)) {
                    continue;
                }
                while (this.lessThan(n6, --n5)) {
                }
                if (n5 < n4) break;
                this.swap(n4, n5);
            }
            this.swap(n4, n2 - 1);
            this.quickSort(n, n5);
            this.quickSort(n4 + 1, n2);
        }
    }

    private void insertionSort(int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            int n3;
            for (n3 = i; n3 > n && this.lessThan(i, n3 - 1); --n3) {
            }
            if (i == n3) continue;
            this.moveAndInsertRow(i, n3);
        }
    }

    protected void moveAndInsertRow(int n, int n2) {
        int n3 = this.keys[n];
        int n4 = this.values[n];
        this.moveRows(n2, n2 + 1, n - n2);
        this.keys[n2] = n3;
        this.values[n2] = n4;
    }

    protected void swap(int n, int n2) {
        int n3 = this.keys[n];
        int n4 = this.values[n];
        this.keys[n] = this.keys[n2];
        this.values[n] = this.values[n2];
        this.keys[n2] = n3;
        this.values[n2] = n4;
    }

    protected int compare(int n) {
        if (this.sortOnValues) {
            if (this.targetSearchValue > this.values[n]) {
                return 1;
            }
            if (this.targetSearchValue < this.values[n]) {
                return -1;
            }
            return 0;
        }
        if (this.targetSearchValue > this.keys[n]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[n]) {
            return -1;
        }
        return 0;
    }

    protected int compare(int n, boolean bl) {
        if (this.sortOnValues) {
            if (this.targetSearchValue > this.values[n]) {
                return 1;
            }
            if (this.targetSearchValue < this.values[n]) {
                return -1;
            }
            if (!bl) {
                return 0;
            }
        }
        if (this.targetSearchValue > this.keys[n]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[n]) {
            return -1;
        }
        return 0;
    }

    protected boolean lessThan(int n, int n2) {
        if (this.sortOnValues) {
            if (this.values[n] < this.values[n2]) {
                return true;
            }
            if (this.values[n] > this.values[n2]) {
                return false;
            }
        }
        return this.keys[n] < this.keys[n2];
    }

    protected void moveRows(int n, int n2, int n3) {
        System.arraycopy(this.keys, n, this.keys, n2, n3);
        System.arraycopy(this.values, n, this.values, n2, n3);
    }

    protected void doubleCapacity() {
        this.keys = (int[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.values = (int[])ArrayUtil.resizeArray(this.values, this.capacity * 2);
        this.capacity *= 2;
    }

    public void removeRange(int n, int n2) {
        ArrayUtil.adjustArray(73, this.keys, this.count, n, n - n2);
        ArrayUtil.adjustArray(73, this.values, this.count, n, n - n2);
        this.count -= n2 - n;
    }

    public void removeAll() {
        this.hasChanged = true;
        ArrayUtil.clearArray(73, this.keys, 0, this.count);
        ArrayUtil.clearArray(73, this.values, 0, this.count);
        this.count = 0;
        this.sorted = true;
    }

    public void copyTo(DoubleIntIndex doubleIntIndex) {
        System.arraycopy(this.keys, 0, doubleIntIndex.keys, 0, this.count);
        System.arraycopy(this.values, 0, doubleIntIndex.values, 0, this.count);
        doubleIntIndex.setSize(this.count);
    }

    public final synchronized void remove(int n) {
        this.hasChanged = true;
        this.moveRows(n + 1, n, this.count - n - 1);
        --this.count;
        this.keys[this.count] = 0;
        this.values[this.count] = 0;
    }

    int peekKey() {
        return this.getKey(this.count - 1);
    }

    int peekValue() {
        return this.getValue(this.count - 1);
    }

    boolean pop() {
        if (this.count > 0) {
            --this.count;
            return true;
        }
        return false;
    }

    boolean push(int n, int n2) {
        return this.addUnsorted(n, n2);
    }
}

