/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

public class PointIteratorFlatten
extends PointIteratorAbstract {
    private PointFeatureCollectionIterator collectionIter;
    private PointIteratorAbstract.Filter filter = null;
    private PointFeatureIterator pfiter;
    private PointFeature pointFeature;
    private boolean finished = false;

    PointIteratorFlatten(PointFeatureCollectionIterator collectionIter, LatLonRect filter_bb, CalendarDateRange filter_date) {
        this.collectionIter = collectionIter;
        if (filter_bb != null || filter_date != null) {
            this.filter = new PointIteratorAbstract.Filter(filter_bb, filter_date);
        }
    }

    @Override
    public void setBufferSize(int bytes) {
        this.collectionIter.setBufferSize(bytes);
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        if (this.pfiter != null) {
            this.pfiter.finish();
        }
        this.collectionIter.finish();
        this.finishCalcBounds();
        this.finished = true;
    }

    @Override
    public boolean hasNext() throws IOException {
        this.pointFeature = this.nextFilteredDataPoint();
        if (this.pointFeature != null) {
            return true;
        }
        PointFeatureCollection feature = this.nextCollection();
        if (feature == null) {
            this.finish();
            return false;
        }
        this.pfiter = feature.getPointFeatureIterator(-1);
        return this.hasNext();
    }

    @Override
    public PointFeature next() throws IOException {
        if (this.pointFeature == null) {
            return null;
        }
        this.calcBounds(this.pointFeature);
        return this.pointFeature;
    }

    private PointFeatureCollection nextCollection() throws IOException {
        if (!this.collectionIter.hasNext()) {
            return null;
        }
        return this.collectionIter.next();
    }

    private PointFeature nextFilteredDataPoint() throws IOException {
        if (this.pfiter == null) {
            return null;
        }
        if (!this.pfiter.hasNext()) {
            return null;
        }
        PointFeature pdata = this.pfiter.next();
        if (this.filter == null) {
            return pdata;
        }
        while (!this.filter.filter(pdata)) {
            if (!this.pfiter.hasNext()) {
                return null;
            }
            pdata = this.pfiter.next();
        }
        return pdata;
    }
}

