/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.entities.domain.effective;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.entities.domain.configuration.AbstractAuditingEntity;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.HistoryStatus;
import org.exoplatform.commons.api.persistence.ExoEntity;

@ExoEntity
@Entity(name="GamificationActionsHistory")
@Table(name="GAMIFICATION_ACTIONS_HISTORY")
@NamedQueries(value={@NamedQuery(name="GamificationActionsHistory.findAllActionsHistory", query="SELECT new org.exoplatform.addons.gamification.service.effective.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM GamificationActionsHistory g WHERE g.earnerType = :earnerType AND g.status <> :status GROUP BY  g.earnerId ORDER BY total DESC"), @NamedQuery(name="GamificationActionsHistory.findActionsHistoryByEarnerIdSortedByDate", query="SELECT g FROM GamificationActionsHistory g WHERE g.earnerId = :earnerId AND g.status <> :status ORDER BY g.createdDate DESC"), @NamedQuery(name="GamificationActionsHistory.findActionsHistoryByEarnerIdAndByType", query="SELECT g FROM GamificationActionsHistory g WHERE g.earnerId = :earnerId AND g.type = :type"), @NamedQuery(name="GamificationActionsHistory.findAllActionsHistoryByDateByDomain", query="SELECT new org.exoplatform.addons.gamification.service.effective.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM GamificationActionsHistory g WHERE g.createdDate >= :date  AND g.domainEntity.id = :domainId AND g.earnerType = :earnerType  AND g.status <> :status GROUP BY  g.earnerId     ORDER BY total DESC"), @NamedQuery(name="GamificationActionsHistory.findActionsHistoryByEarnerId", query="SELECT a FROM GamificationActionsHistory a WHERE a.earnerId = :earnerId     ORDER BY a.globalScore DESC"), @NamedQuery(name="GamificationActionsHistory.findAllActionsHistoryByDomain", query="SELECT new org.exoplatform.addons.gamification.service.effective.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM GamificationActionsHistory g WHERE g.domainEntity.id = :domainId AND g.earnerType = :earnerType AND g.status <> :status GROUP BY  g.earnerId ORDER BY total DESC"), @NamedQuery(name="GamificationActionsHistory.findActionHistoryByDateByEarnerId", query="SELECT a FROM GamificationActionsHistory a WHERE a.createdDate = :date     AND a.earnerId = :earnerId     ORDER BY a.globalScore DESC"), @NamedQuery(name="GamificationActionsHistory.findActionsHistoryByDate", query="SELECT new org.exoplatform.addons.gamification.service.effective.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM GamificationActionsHistory g  WHERE g.createdDate >= :date  AND g.earnerType = :earnerType AND g.status <> :status GROUP BY  g.earnerId ORDER BY total DESC"), @NamedQuery(name="GamificationActionsHistory.findActionsHistoryByDateByDomain", query="SELECT new org.exoplatform.addons.gamification.service.effective.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM GamificationActionsHistory g WHERE g.createdDate >= :date     AND g.domainEntity.id = :domainId     AND g.earnerType = :earnerType     GROUP BY  g.earnerId     ORDER BY total DESC"), @NamedQuery(name="GamificationActionsHistory.findStatsByUser", query="SELECT new org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard(g.domainEntity.title,SUM(g.actionScore)) FROM GamificationActionsHistory g WHERE g.earnerId = :earnerId     GROUP BY  g.domainEntity.title"), @NamedQuery(name="GamificationActionsHistory.findStatsByUserByDates", query="SELECT new org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard(g.domainEntity.title,SUM(g.actionScore)) FROM GamificationActionsHistory g WHERE g.earnerId = :earnerId AND g.createdDate >= :fromDate AND g.createdDate < :toDate GROUP BY  g.domainEntity.title ORDER BY SUM(g.actionScore) DESC"), @NamedQuery(name="GamificationActionsHistory.findDomainScoreByUserId", query="SELECT new org.exoplatform.addons.gamification.service.effective.ProfileReputation(g.domainEntity.id,SUM(g.actionScore)) FROM GamificationActionsHistory g WHERE g.earnerId = :earnerId AND g.domainEntity IS NOT NULL GROUP BY  g.domainEntity.id"), @NamedQuery(name="GamificationActionsHistory.findUserReputationScoreBetweenDate", query="SELECT SUM(g.actionScore) as total FROM GamificationActionsHistory g  WHERE g.earnerId = :earnerId AND g.status <> :status AND g.createdDate >= :fromDate AND g.createdDate < :toDate"), @NamedQuery(name="GamificationActionsHistory.findUsersReputationScoreBetweenDate", query="SELECT g.earnerId,SUM(g.actionScore) as total FROM GamificationActionsHistory g  WHERE g.earnerId IN :earnersId AND g.status <> :status AND g.createdDate >= :fromDate AND g.createdDate < :toDate GROUP BY g.earnerId"), @NamedQuery(name="GamificationActionsHistory.findUserReputationScoreByMonth", query="SELECT SUM(g.actionScore) as total FROM GamificationActionsHistory g WHERE g.earnerId = :earnerId AND g.createdDate >= :currentMonth"), @NamedQuery(name="GamificationActionsHistory.findUserReputationScoreByDomainBetweenDate", query="SELECT SUM(g.actionScore) as total FROM GamificationActionsHistory g WHERE g.earnerId = :earnerId     AND g.domainEntity.id = :domainId     AND g.createdDate >= :fromDate AND g.createdDate < :toDate"), @NamedQuery(name="GamificationActionsHistory.findAllLeaderboardBetweenDate", query="SELECT new org.exoplatform.addons.gamification.service.effective.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM GamificationActionsHistory g WHERE g.createdDate >= :fromDate AND g.createdDate < :toDate AND g.earnerType = :earnerType GROUP BY  g.earnerId ORDER BY total DESC"), @NamedQuery(name="GamificationActionsHistory.computeTotalScore", query="SELECT SUM(a.actionScore) FROM GamificationActionsHistory a WHERE a.earnerId = :earnerId"), @NamedQuery(name="GamificationActionsHistory.getAllPointsByDomain", query="SELECT g FROM GamificationActionsHistory g WHERE g.domainEntity.id = :domainId "), @NamedQuery(name="GamificationActionsHistory.countAnnouncementsByChallenge", query="SELECT COUNT(a) FROM GamificationActionsHistory a where a.ruleEntity.id = :challengeId"), @NamedQuery(name="GamificationActionsHistory.countAnnouncementsByChallengeAndEarnerType", query="SELECT COUNT(a) FROM GamificationActionsHistory a where a.ruleEntity.id = :challengeId AND a.earnerType = :earnerType"), @NamedQuery(name="GamificationActionsHistory.findAllAnnouncementByChallenge", query="SELECT a FROM GamificationActionsHistory a where a.ruleEntity.id = :challengeId order by a.id desc"), @NamedQuery(name="GamificationActionsHistory.findAllAnnouncementByChallengeByEarnerType", query="SELECT a FROM GamificationActionsHistory a where a.ruleEntity.id = :challengeId AND a.earnerType = :earnerType order by a.id desc"), @NamedQuery(name="GamificationActionsHistory.findAllAnnouncementByChallengeByDate", query="SELECT a FROM GamificationActionsHistory a where a.ruleEntity.id = :challengeId AND a.createdDate >= :fromDate AND a.createdDate < :toDate order by a.id desc"), @NamedQuery(name="GamificationActionsHistory.findAllAnnouncementByChallengeByDateByEarnerType", query="SELECT a FROM GamificationActionsHistory a where a.ruleEntity.id = :challengeId AND a.createdDate >= :fromDate AND a.createdDate < :toDate AND a.earnerType = :earnerType order by a.id desc"), @NamedQuery(name="GamificationActionsHistory.findMostRealizedRuleIds", query="SELECT r.id FROM GamificationActionsHistory a JOIN a.ruleEntity r  ON  (r.startDate IS NULL OR r.startDate <= :nowDate) AND (r.endDate IS NULL OR r.endDate >= :nowDate) AND r.isEnabled = true AND r.isDeleted = false JOIN a.domainEntity d  ON d.audienceId IS NULL OR d.audienceId IN (:spacesIds) WHERE a.type= :type AND a.createdDate >= :fromDate AND a.createdDate < :toDate group by r.id order by count(*) DESC")})
public class GamificationActionsHistory
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_SCORE_HISTORY_ID", sequenceName="SEQ_GAMIFICATION_SCORE_HISTORY_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GAMIFICATION_SCORE_HISTORY_ID")
    @Column(name="ID")
    protected Long id;
    @Column(name="EARNER_ID", nullable=false)
    private String earnerId;
    @Column(name="EARNER_TYPE", nullable=false)
    private IdentityType earnerType;
    @Column(name="GLOBAL_SCORE", nullable=false)
    protected long globalScore;
    @Column(name="ACTION_TITLE", nullable=false)
    private String actionTitle;
    @Column(name="DOMAIN", nullable=false)
    private String domain;
    @Column(name="CONTEXT", nullable=true)
    private String context;
    @Column(name="ACTION_SCORE", nullable=false)
    private long actionScore;
    @Column(name="RECEIVER", nullable=false)
    private String receiver;
    @Column(name="OBJECT_ID", nullable=false)
    private String objectId;
    @ManyToOne
    @JoinColumn(name="DOMAIN_ID")
    private DomainEntity domainEntity;
    @ManyToOne
    @JoinColumn(name="RULE_ID")
    private RuleEntity ruleEntity;
    @Column(name="ACTIVITY_ID")
    private Long activityId;
    @Column(name="COMMENT")
    private String comment;
    @Column(name="CREATOR_ID")
    private Long creator;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="STATUS", nullable=false)
    private HistoryStatus status;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TYPE", nullable=false)
    private EntityType type;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEarnerId() {
        return this.earnerId;
    }

    public void setEarnerId(String earnerId) {
        this.earnerId = earnerId;
    }

    public IdentityType getEarnerType() {
        return this.earnerType;
    }

    public void setEarnerType(IdentityType earnerType) {
        this.earnerType = earnerType;
    }

    public long getGlobalScore() {
        return this.globalScore;
    }

    public void setGlobalScore(long globalScore) {
        this.globalScore = globalScore;
    }

    public String getActionTitle() {
        return this.actionTitle;
    }

    public void setActionTitle(String actionTitle) {
        this.actionTitle = actionTitle;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public long getActionScore() {
        return this.actionScore;
    }

    public void setActionScore(long actionScore) {
        this.actionScore = actionScore;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public DomainEntity getDomainEntity() {
        return this.domainEntity;
    }

    public void setDomainEntity(DomainEntity domainEntity) {
        this.domainEntity = domainEntity;
    }

    public RuleEntity getRuleEntity() {
        return this.ruleEntity;
    }

    public void setRuleEntity(RuleEntity ruleEntity) {
        this.ruleEntity = ruleEntity;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Long getCreator() {
        return this.creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public HistoryStatus getStatus() {
        return this.status;
    }

    public void setStatus(HistoryStatus status) {
        this.status = status;
    }

    public EntityType getType() {
        return this.type;
    }

    public void setType(EntityType type) {
        this.type = type;
    }
}

