/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.cached;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.addons.gamification.service.dto.configuration.CacheKey;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityStatusType;
import org.exoplatform.addons.gamification.storage.DomainStorage;
import org.exoplatform.addons.gamification.storage.dao.DomainDAO;
import org.exoplatform.addons.gamification.storage.dao.RuleDAO;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.upload.UploadService;

public class DomainCachedStorage
extends DomainStorage {
    private static final int DOMAIN_ID_CONTEXT = 0;
    private static final int ALL_DOMAIN_CONTEXT = 2;
    private static final int DOMAIN_ENABLED_CONTEXT = 3;
    private static final String DOMAIN_CACHE_NAME = "gamification.domain";
    private FutureExoCache<Serializable, Object, CacheKey> domainFutureCache;

    public DomainCachedStorage(DomainDAO domainDAO, FileService fileService, UploadService uploadService, CacheService cacheService, RuleDAO ruleDAO) {
        super(domainDAO, fileService, uploadService, ruleDAO);
        ExoCache domainCache = cacheService.getCacheInstance(DOMAIN_CACHE_NAME);
        Loader<Serializable, Object, CacheKey> domainLoader = new Loader<Serializable, Object, CacheKey>(){

            public Object retrieve(CacheKey context, Serializable key) throws Exception {
                if (context.getContext() == 0) {
                    return DomainCachedStorage.super.getDomainById(context.getId());
                }
                if (context.getContext() == 2) {
                    return DomainCachedStorage.super.getDomainsByFilter(context.getDomainFilter(), context.getOffset(), context.getLimit());
                }
                if (context.getContext() == 3) {
                    return DomainCachedStorage.super.getEnabledDomains();
                }
                throw new IllegalStateException("Unknown context id " + context);
            }
        };
        this.domainFutureCache = new FutureExoCache((Loader)domainLoader, domainCache);
    }

    @Override
    public DomainDTO saveDomain(DomainDTO domain) {
        try {
            DomainDTO domainDTO = domain = super.saveDomain(domain);
            return domainDTO;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public DomainDTO getDomainById(Long id) {
        CacheKey key = new CacheKey((Integer)0, id);
        return (DomainDTO)this.domainFutureCache.get((Object)key, (Object)key.hashCode());
    }

    @Override
    public List<DomainDTO> getEnabledDomains() {
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setEntityStatusType(EntityStatusType.ENABLED);
        CacheKey key = new CacheKey((Integer)3, domainFilter);
        return (List)this.domainFutureCache.get((Object)key, (Object)key.hashCode());
    }

    @Override
    public void clearCache() {
        this.domainFutureCache.clear();
    }
}

