/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.lang.reflect.Method;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;

public class StorageUtils {
    private static final Log LOG = ExoLogger.getLogger((String)StorageUtils.class.getName());
    public static final String ASTERISK_STR = "*";
    public static final String PERCENT_STR = "%";
    public static final char ASTERISK_CHAR = '*';
    public static final String SPACE_STR = " ";
    public static final String EMPTY_STR = "";
    public static final String SLASH_STR = "/";
    public static final String COLON_STR = ":";
    public static final String SOC_RELATIONSHIP = "soc:relationship";
    public static final String SOC_RELCEIVER = "soc:receiver";
    public static final String SOC_SENDER = "soc:sender";
    public static final String SOC_IGNORED = "soc:ignored";
    public static final String SOC_FROM = "soc:from";
    public static final String SOC_TO = "soc:to";
    public static final String SOC_ACTIVITY_INFO = "soc:activityInfo";
    public static final String SOC_PREFIX = "soc:";
    public static final DateTimeFormatter RFC_3339_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS][XXX]").withResolverStyle(ResolverStyle.LENIENT);
    private static final long DAY_MILISECONDS = 86400000L;
    private static Class<?> cls;

    public static String processUsernameSearchPattern(String userName) {
        Object modifiedUserName = userName;
        if (((String)modifiedUserName).length() > 0) {
            modifiedUserName = EMPTY_STR.equals(modifiedUserName) || ((String)modifiedUserName).length() == 0 ? ASTERISK_STR : modifiedUserName;
            modifiedUserName = ((String)modifiedUserName).charAt(0) != '*' ? ASTERISK_STR + (String)modifiedUserName : modifiedUserName;
            modifiedUserName = ((String)modifiedUserName).charAt(((String)modifiedUserName).length() - 1) != '*' ? (modifiedUserName = (String)modifiedUserName + ASTERISK_STR) : modifiedUserName;
            modifiedUserName = ((String)modifiedUserName).indexOf(ASTERISK_STR) >= 0 ? ((String)modifiedUserName).replace(ASTERISK_STR, ".*") : modifiedUserName;
            modifiedUserName = ((String)modifiedUserName).indexOf(PERCENT_STR) >= 0 ? ((String)modifiedUserName).replace(PERCENT_STR, ".*") : modifiedUserName;
            Pattern.compile((String)modifiedUserName);
        }
        return userName;
    }

    public static String addAsteriskToStringInput(String input) {
        if (input.length() != 0) {
            if (input.indexOf(ASTERISK_STR) == -1) {
                return ASTERISK_STR + input + ASTERISK_STR;
            }
            return input;
        }
        return EMPTY_STR;
    }

    public static List<String> processUnifiedSearchCondition(String searchCondition) {
        String[] spaceConditions = searchCondition.split(SPACE_STR);
        ArrayList<String> result = new ArrayList<String>(spaceConditions.length);
        for (String conditionValue : spaceConditions) {
            result.add(conditionValue);
        }
        return result;
    }

    public static <T> int getCommonItemNumber(List<T> m, List<T> n) {
        if (m == null || n == null) {
            return 0;
        }
        ArrayList<T> copy = new ArrayList<T>(m);
        copy.removeAll(n);
        return m.size() - copy.size();
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortMapByValue(Map<K, V> map, final boolean asc) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                if (asc) {
                    return ((Comparable)o1.getValue()).compareTo(o2.getValue());
                }
                return ((Comparable)o1.getValue()).compareTo(o2.getValue()) / -1;
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }

    public static List<Space> sortSpaceByName(List<Space> list, final boolean asc) {
        Collections.sort(list, new Comparator<Space>(){

            @Override
            public int compare(Space o1, Space o2) {
                if (asc) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
                return o1.getDisplayName().compareTo(o2.getDisplayName()) / -1;
            }
        });
        return list;
    }

    public static List<Identity> sortIdentitiesByFullName(List<Identity> list, final boolean asc) {
        Collections.sort(list, new Comparator<Identity>(){

            @Override
            public int compare(Identity o1, Identity o2) {
                if (asc) {
                    return o1.getProfile().getFullName().compareTo(o2.getProfile().getFullName());
                }
                return o1.getProfile().getFullName().compareTo(o2.getProfile().getFullName()) / -1;
            }
        });
        return list;
    }

    public static List<ExoSocialActivity> sortActivitiesByTime(List<ExoSocialActivity> list, int limit) {
        Collections.sort(list, new Comparator<ExoSocialActivity>(){

            @Override
            public int compare(ExoSocialActivity a1, ExoSocialActivity a2) {
                return Long.valueOf(a1.getUpdated().getTime()).compareTo(a2.getUpdated().getTime()) / -1;
            }
        });
        return list.size() > limit ? list.subList(0, limit - 1) : list;
    }

    public static <T> List<T> subList(List<T> list, int startIndex, int toIndex) {
        int totalSize = list.size();
        if (startIndex >= totalSize) {
            return Collections.emptyList();
        }
        if (toIndex >= totalSize) {
            toIndex = totalSize;
        }
        return list.subList(startIndex, toIndex);
    }

    public static String[] sub(String[] l1, String[] l2) {
        if (l1 == null) {
            return new String[0];
        }
        if (l2 == null) {
            return l1;
        }
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(l1));
        l.removeAll(Arrays.asList(l2));
        return l.toArray(new String[0]);
    }

    public static Set<String> getLastLogin(int aroundDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 0 - aroundDays);
        long fromDay = calendar.getTimeInMillis();
        try {
            if (cls != null) {
                Class[] params = new Class[]{Long.TYPE};
                Method method = cls.getMethod("getLastUsersLogin", params);
                Object obj = CommonsUtils.getService(cls);
                return (Set)method.invoke(obj, fromDay);
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to invoke method " + e.getMessage()));
            return null;
        }
    }

    public static boolean isActiveUser(int aroundDays, long lazilyCreatedTime) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.get(5) - aroundDays);
        long limitTime = cal.getTimeInMillis();
        return lazilyCreatedTime >= limitTime;
    }

    public static long getBeforeLastLogin(String userId) {
        try {
            if (cls != null) {
                Class[] params = new Class[]{String.class};
                Method method = cls.getMethod("getBeforeLastLogin", params);
                Object obj = CommonsUtils.getService(cls);
                return (Long)method.invoke(obj, userId);
            }
            return 0L;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to invoke method " + e.getMessage()), (Throwable)e);
            return 0L;
        }
    }

    public static Map<String, Integer> getActiveUsers(int aroundDays) {
        try {
            if (cls != null) {
                Class[] params = new Class[]{Integer.TYPE};
                Method method = cls.getMethod("getActiveUsers", params);
                Object obj = CommonsUtils.getService(cls);
                return (Map)method.invoke(obj, aroundDays);
            }
            return new HashMap<String, Integer>();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to invoke method " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static boolean afterDayOrMore(long oldDate, long newDate) {
        long diffValue = newDate - oldDate;
        return diffValue >= 86400000L;
    }

    public static List<String> getIds(List<ExoSocialActivity> activities) {
        LinkedList<String> ids = new LinkedList<String>();
        for (ExoSocialActivity a : activities) {
            ids.add(a.getId());
        }
        return ids;
    }

    public static String toRFC3339Date(Date dateTime) {
        if (dateTime == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = dateTime.toInstant().atZone(ZoneOffset.UTC);
        return zonedDateTime.format(RFC_3339_FORMATTER);
    }

    public static Date parseRFC3339Date(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateString, RFC_3339_FORMATTER);
        return Date.from(zonedDateTime.toInstant());
    }

    static {
        try {
            cls = Class.forName("org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryServiceImpl");
        }
        catch (ClassNotFoundException e) {
            cls = null;
            LOG.error((Object)("org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryServiceImpl class not found." + e.getMessage()));
        }
    }
}

