/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.model.AgendaUserSettings;
import org.exoplatform.agenda.model.RemoteProvider;
import org.exoplatform.agenda.service.AgendaEventConferenceService;
import org.exoplatform.agenda.service.AgendaRemoteEventService;
import org.exoplatform.agenda.service.AgendaUserSettingsService;
import org.exoplatform.agenda.service.AgendaWebSocketService;
import org.exoplatform.agenda.util.RestUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/v1/agenda/settings")
@Tag(name="/v1/agenda/settings", description="Manages agenda settings associated to users")
public class AgendaSettingsRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(AgendaSettingsRest.class);
    private AgendaUserSettingsService agendaUserSettingsService;
    private AgendaEventConferenceService agendaEventConferenceService;
    private AgendaRemoteEventService agendaRemoteEventService;
    private AgendaWebSocketService agendaWebSocketService;
    private IdentityManager identityManager;

    public AgendaSettingsRest(AgendaUserSettingsService agendaUserSettingsService, AgendaEventConferenceService agendaEventConferenceService, AgendaRemoteEventService agendaRemoteEventService, AgendaWebSocketService agendaWebSocketService, IdentityManager identityManager) {
        this.agendaUserSettingsService = agendaUserSettingsService;
        this.agendaEventConferenceService = agendaEventConferenceService;
        this.agendaRemoteEventService = agendaRemoteEventService;
        this.agendaWebSocketService = agendaWebSocketService;
        this.identityManager = identityManager;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get User agenda settings", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getUserSettings() {
        Identity currentUserIdentity = RestUtils.getCurrentUserIdentity(this.identityManager);
        try {
            long identityId = Long.parseLong(currentUserIdentity.getId());
            AgendaUserSettings agendaUserSettings = this.agendaUserSettingsService.getAgendaUserSettings(identityId);
            String cometdToken = this.agendaWebSocketService.getUserToken(currentUserIdentity.getRemoteId());
            agendaUserSettings.setCometdToken(cometdToken);
            agendaUserSettings.setCometdContextName(this.agendaWebSocketService.getCometdContextName());
            return Response.ok((Object)agendaUserSettings).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving agenda settings for user with id '{}'", new Object[]{currentUserIdentity, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Saves agenda settings for authenticated user", description="Saves agenda settings for authenticated user", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveUserSettings(@Parameter(description="User agenda settings to update", required=true) AgendaUserSettings agendaUserSettings) {
        if (agendaUserSettings == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Agenda settings object is mandatory").build();
        }
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            this.agendaUserSettingsService.saveAgendaUserSettings(identityId, agendaUserSettings);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving agenda settings for user with id '{}'", new Object[]{identityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="timeZone")
    @PATCH
    @RolesAllowed(value={"users"})
    @Operation(summary="Saves agenda time zone setting for authenticated user", description="Saves agenda time zone setting for authenticated user", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveUserTimeZoneSetting(@Parameter(description="User preferred time zone", required=true) @FormParam(value="timeZoneId") String timeZoneId) {
        if (StringUtils.isBlank((CharSequence)timeZoneId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'timeZoneId' parameter is mandatory").build();
        }
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            AgendaUserSettings agendaUserSettings = this.agendaUserSettingsService.getAgendaUserSettings(identityId);
            agendaUserSettings.setTimeZoneId(timeZoneId);
            this.agendaUserSettingsService.saveAgendaUserSettings(identityId, agendaUserSettings);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving agenda timezone settings for user with id '{}'", new Object[]{identityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="connector/status")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Saves agenda connector status whether enabled or disabled for all users", description="Saves agenda connector status whether enabled or disabled for all users", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveRemoteProviderStatus(@Parameter(description="Remote connector name", required=true) @FormParam(value="connectorName") String connectorName, @Parameter(description="Remote connector status", required=true) @FormParam(value="enabled") boolean enabled, @Parameter(description="Remote connector uses Oauth or not", required=true) @FormParam(value="isOauth") boolean isOauth) {
        if (StringUtils.isBlank((CharSequence)connectorName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'connectorName' parameter is mandatory").build();
        }
        try {
            RemoteProvider remoteProvider = this.agendaRemoteEventService.saveRemoteProviderStatus(connectorName, enabled, isOauth);
            return Response.ok((Object)remoteProvider).build();
        }
        catch (Exception e) {
            LOG.warn("Error saving connector '{}' status", new Object[]{connectorName, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="connector/apiKey")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Saves agenda connector Client API Key that will be accessible by all users to access connector remote API", description="Saves agenda connector Client API Key that will be accessible by all users to access connector remote API", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveRemoteProviderApiKey(@Parameter(description="Remote connector name", required=true) @FormParam(value="connectorName") String connectorName, @Parameter(description="Remote connector Api Key", required=true) @FormParam(value="apiKey") String apiKey) {
        if (StringUtils.isBlank((CharSequence)connectorName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'connectorName' parameter is mandatory").build();
        }
        try {
            RemoteProvider remoteProvider = this.agendaRemoteEventService.saveRemoteProviderApiKey(connectorName, apiKey);
            return Response.ok((Object)remoteProvider).build();
        }
        catch (Exception e) {
            LOG.warn("Error saving connector '{}' apiKey", new Object[]{connectorName, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="connector/secretKey")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Saves agenda connector Client Secret Key that will be accessible by all users to access connector remote API", description="Saves agenda connector Client Secret Key that will be accessible by all users to access connector remote API", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveRemoteProviderSecretKey(@Parameter(description="Remote connector name", required=true) @FormParam(value="connectorName") String connectorName, @Parameter(description="Remote connector Secret Key", required=true) @FormParam(value="secretKey") String secretKey) {
        if (StringUtils.isBlank((CharSequence)connectorName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'connectorName' parameter is mandatory").build();
        }
        try {
            RemoteProvider remoteProvider = this.agendaRemoteEventService.saveRemoteProviderSecretKey(connectorName, secretKey);
            return Response.ok((Object)remoteProvider).build();
        }
        catch (Exception e) {
            LOG.warn("Error saving connector '{}' secretKey", new Object[]{connectorName, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="webConferencing")
    @POST
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Saves enabled web conferencing provider to use for all users", description="Saves enabled web conferencing provider to use for all users", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveEnabledWebConferencing(@Parameter(description="Web conferencing provider name", required=true) @FormParam(value="providerName") String providerName) {
        try {
            providerName = providerName == null ? "" : providerName.trim();
            this.agendaEventConferenceService.saveEnabledWebConferenceProviders(Collections.singletonList(providerName));
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving enabled web conferencing provider '{}' status", new Object[]{providerName, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="connector")
    @PATCH
    @RolesAllowed(value={"users"})
    @Operation(summary="Saves agenda connector settings for authenticated user", description="Saves agenda connector settings for authenticated user", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveUserConnectorSettings(@Parameter(description="User connector name", required=true) @FormParam(value="connectorName") String connectorName, @Parameter(description="User connector identifier", required=true) @FormParam(value="connectorUserId") String connectorUserId) {
        if (StringUtils.isBlank((CharSequence)connectorName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'connectorName' parameter is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)connectorUserId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'connectorUserId' parameter is mandatory").build();
        }
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            this.agendaUserSettingsService.saveUserConnector(connectorName, connectorUserId, identityId);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving agenda settings for user with id '{}'", new Object[]{identityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="connector")
    @DELETE
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes agenda connector settings for authenticated user", description="Deletes agenda connector settings for authenticated user", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteUserConnectorSettings() {
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            AgendaUserSettings agendaUserSettings = this.agendaUserSettingsService.getAgendaUserSettings(identityId);
            agendaUserSettings.setConnectedRemoteUserId(null);
            agendaUserSettings.setConnectedRemoteProvider(null);
            this.agendaUserSettingsService.saveAgendaUserSettings(identityId, agendaUserSettings);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error deleting agenda connector settings for user with id '{}'", new Object[]{identityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

