/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.services.cms.documents.DocumentTypeService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}, csrfCheck=false)})
public class UIDocumentFilterForm
extends UIForm
implements UIPopupComponent {
    public void activate() {
    }

    public void deActivate() {
    }

    public void invoke(List<String> checkedTypes) {
        DocumentTypeService documentTypeService = (DocumentTypeService)this.getApplicationComponent(DocumentTypeService.class);
        List supportedTypes = documentTypeService.getAllSupportedType();
        for (String supportedName : supportedTypes) {
            this.addUIFormInput((UIFormInput)new UICheckBoxInput(supportedName, supportedName, null));
            for (String checkedTypeName : checkedTypes) {
                if (!supportedName.equals(checkedTypeName)) continue;
                this.getUICheckBoxInput(supportedName).setChecked(true);
            }
        }
    }

    public static class CancelActionListener
    extends EventListener<UIDocumentFilterForm> {
        public void execute(Event<UIDocumentFilterForm> event) throws Exception {
            UIDocumentFilterForm uiForm = (UIDocumentFilterForm)((Object)event.getSource());
            UIJCRExplorerPortlet explorerPorltet = (UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)explorerPorltet.findFirstComponentOfType(UIJCRExplorer.class);
            ((UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class)).cancelPopupAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UIDocumentFilterForm> {
        public void execute(Event<UIDocumentFilterForm> event) throws Exception {
            UIDocumentFilterForm uiForm = (UIDocumentFilterForm)((Object)event.getSource());
            UIJCRExplorerPortlet uiExplorerPorltet = (UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiExplorerPorltet.findFirstComponentOfType(UIJCRExplorer.class);
            DocumentTypeService documentTypeService = (DocumentTypeService)uiForm.getApplicationComponent(DocumentTypeService.class);
            List supportedTypes = documentTypeService.getAllSupportedType();
            ArrayList<String> checkedSupportTypes = new ArrayList<String>();
            for (String checkedName : supportedTypes) {
                if (!uiForm.getUICheckBoxInput(checkedName).isChecked()) continue;
                checkedSupportTypes.add(checkedName);
            }
            uiExplorer.setCheckedSupportType(checkedSupportTypes);
            uiExplorer.setFilterSave(true);
            uiExplorer.refreshExplorer();
            uiExplorerPorltet.setRenderedChild(UIJCRExplorer.class);
        }
    }
}

