/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tasks.listener.analytics;

import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.task.domain.LabelTaskMapping;

@Asynchronous
public class TaskLabelListener
extends Listener<String, LabelTaskMapping> {
    private PortalContainer container = PortalContainer.getInstance();
    private final String operation;

    public TaskLabelListener(InitParams params) {
        this.operation = params.getValueParam("operation").getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExoTransactional
    public void onEvent(Event<String, LabelTaskMapping> event) {
        RequestLifeCycle.begin((ExoContainer)this.container);
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        try {
            LabelTaskMapping labelTaskMapping = (LabelTaskMapping)event.getData();
            String userName = (String)event.getSource();
            this.createLabelStatistic(labelTaskMapping, userName);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void createLabelStatistic(LabelTaskMapping labelTaskMapping, String userName) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("tasks");
        statisticData.setSubModule("task");
        statisticData.setUserId(AnalyticsUtils.getUserIdentityId((String)userName));
        statisticData.setOperation(this.operation);
        if (labelTaskMapping.getTask() != null) {
            statisticData.addParameter("taskId", (Object)labelTaskMapping.getTask().getId());
        }
        if (labelTaskMapping.getLabel() != null) {
            statisticData.addParameter("labelId", (Object)labelTaskMapping.getLabel().getId());
            if (labelTaskMapping.getLabel().getProject() != null) {
                statisticData.addParameter("projectId", (Object)labelTaskMapping.getLabel().getProject().getId());
            }
        }
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }
}

