/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.io.Serializable;
import org.gatein.api.internal.ObjectToStringBuilder;
import org.gatein.api.internal.Parameters;
import org.gatein.api.navigation.PublicationDate;

public class Visibility
implements Serializable {
    private final Status status;
    private final PublicationDate publicationDate;

    public Visibility() {
        this(Status.VISIBLE);
    }

    public Visibility(Status status) {
        this.status = Parameters.requireNonNull(status, "status");
        this.publicationDate = null;
    }

    public Visibility(PublicationDate publicationDate) {
        this.status = Status.PUBLICATION;
        this.publicationDate = Parameters.requireNonNull(publicationDate, "publicationDate");
    }

    public boolean isVisible() {
        switch (this.status) {
            case VISIBLE: {
                return true;
            }
            case PUBLICATION: {
                return this.publicationDate.within(System.currentTimeMillis());
            }
        }
        return false;
    }

    public Status getStatus() {
        return this.status;
    }

    public PublicationDate getPublicationDate() {
        return this.publicationDate;
    }

    public String toString() {
        return ObjectToStringBuilder.toStringBuilder().add("flag", (Object)this.status).add("publicationDate", this.publicationDate).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Visibility)) {
            return false;
        }
        Visibility that = (Visibility)o;
        if (this.status != that.status) {
            return false;
        }
        if (this.publicationDate == null) {
            return that.publicationDate == null;
        }
        return that.publicationDate != null && this.publicationDate.equals(that.publicationDate);
    }

    public int hashCode() {
        int result = this.status.hashCode();
        result = 31 * result + (this.publicationDate != null ? this.publicationDate.hashCode() : 0);
        return result;
    }

    public static enum Status {
        VISIBLE,
        SYSTEM,
        PUBLICATION,
        HIDDEN;

    }
}

