/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import java.io.InputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.context.DocumentContext;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.ActivityTypeUtils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.cssfile.CssClassManager;
import org.exoplatform.webui.cssfile.CssClassUtils;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    public static final String CONTENT_SPACES = "contents:spaces";
    public static final String FILE_SPACES = "files:spaces";
    public static final String SHARE_FILE = "sharefiles:spaces";
    public static final String SHARE_CONTENT = "sharecontents:spaces";
    public static final String CURRENT_STATE_PROP = "publication:currentState";
    public static final String EXO_RESOURCES_URI = "/eXoSkin/skin/images/themes/default/Icons/TypeIcons/EmailNotificationIcons/";
    public static final String ICON_FILE_EXTENSION = ".png";
    public static final String DEFAULT_AVATAR = "/eXoSkin/skin/images/themes/default/social/skin/ShareImages/UserAvtDefault.png";
    public static int MAX_SUMMARY_LINES_COUNT = 4;
    private static String MIX_COMMENT = "exo:activityComment";
    private static String MIX_COMMENT_ID = "exo:activityCommentID";
    public static int MAX_SUMMARY_CHAR_COUNT = 430;
    private static String activityType;
    private static final String CREATION_MESSAGE = "files:spaces.CREATION_COMMENT";
    private static final String RENAME_COMMENT = "files:spaces.RENAME_COMMENT";
    private static final String MOVE_COMMENT = "files:spaces.MOVE_COMMENT";
    private static final String RESOURCE_BUNDLE_KEY_CREATED_BY = "SocialIntegration.messages.createdBy";
    private static final String RESOURCE_BUNDLE_KEY_FILE_RENAMED = "SocialIntegration.messages.rename";
    private static final String RESOURCE_BUNDLE_KEY_FILE_MOVED = "SocialIntegration.messages.fileMoved";

    public static String getActivityType() {
        return activityType;
    }

    public static void setActivityType(String activityType) {
        Utils.activityType = activityType;
    }

    public static Map<String, String> populateActivityData(Node node, String activityOwnerId, String activityMsgBundleKey) throws Exception {
        return Utils.populateActivityData(node, activityOwnerId, activityMsgBundleKey, false, null, null);
    }

    public static Map<String, String> populateActivityData(Node node, String activityOwnerId, String activityMsgBundleKey, boolean isComment, String systemComment, String perm) throws Exception {
        Node contentNode;
        String illustrationImg;
        SimpleDateFormat dateFormatter = null;
        dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        LinkManager linkManager = (LinkManager)CommonsUtils.getService(LinkManager.class);
        if (node.canAddMixin("mix:referenceable")) {
            node.addMixin("mix:referenceable");
            node.save();
        }
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String workspace = node.getSession().getWorkspace().getName();
        try {
            illustrationImg = Utils.getIllustrativeImage(node);
        }
        catch (Exception ex) {
            illustrationImg = "";
        }
        String strDateCreated = "";
        if (node.hasProperty("exo:dateCreated")) {
            Calendar dateCreated = node.getProperty("exo:dateCreated").getDate();
            strDateCreated = dateFormatter.format(dateCreated.getTime());
        }
        String strLastModified = "";
        if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:lastModified")) {
            Calendar lastModified = contentNode.getProperty("jcr:lastModified").getDate();
            strLastModified = dateFormatter.format(lastModified.getTime());
        }
        activityOwnerId = activityOwnerId != null ? activityOwnerId : "";
        HashMap<String, String> activityParams = new HashMap<String, String>();
        activityParams.put("nodeUUID", node.getUUID());
        activityParams.put("contentName", node.getName());
        activityParams.put("author", activityOwnerId);
        activityParams.put("dateCreated", strDateCreated);
        activityParams.put("lastModified", strLastModified);
        activityParams.put("contenLink", Utils.getContentLink(node));
        activityParams.put("id", node.isNodeType("mix:referenceable") ? node.getUUID() : "");
        activityParams.put("REPOSITORY", repository);
        activityParams.put("WORKSPACE", workspace);
        activityParams.put("MESSAGE", activityMsgBundleKey);
        activityParams.put("mimeType", Utils.getMimeType(linkManager.isLink((Item)node) ? linkManager.getTarget(node, true) : node));
        activityParams.put("imagePath", illustrationImg);
        activityParams.put("imagePath", illustrationImg);
        if (isComment && StringUtils.isNotBlank((String)systemComment)) {
            activityParams.put("isSystemComment", String.valueOf(isComment));
            activityParams.put("systemComment", systemComment);
        } else {
            activityParams.put("isSystemComment", String.valueOf(false));
            activityParams.put("systemComment", "");
        }
        activityParams.put("permission", perm);
        activityParams.put("comment", systemComment);
        activityParams.put("thumbnail", Utils.getThumbnailUrl(node, repository, workspace) != null ? Utils.getThumbnailUrl(node, repository, workspace) : Utils.getDefaultThumbnailUrl(node));
        activityParams.put("nodePath", node.getPath());
        String nodeTitle = node.getName();
        try {
            nodeTitle = org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)node);
        }
        catch (Exception exception) {
            // empty catch block
        }
        activityParams.put("docTitle", nodeTitle);
        return activityParams;
    }

    private static String getDefaultThumbnailUrl(Node node) throws RepositoryException {
        LinkManager linkManager = (LinkManager)CommonsUtils.getService(LinkManager.class);
        String cssClass = CssClassUtils.getCSSClassByFileNameAndFileType((String)node.getName(), (String)Utils.getMimeType(linkManager.isLink((Item)node) ? linkManager.getTarget(node, true) : node), (CssClassManager.ICON_SIZE)CssClassManager.ICON_SIZE.ICON_64);
        if (cssClass.indexOf("FileDefault") > 0) {
            return CommonsUtils.getCurrentDomain() + "/eXoSkin/skin/images/themes/default/Icons/TypeIcons/EmailNotificationIcons/uiIcon64x64Templatent_file.png";
        }
        return CommonsUtils.getCurrentDomain() + EXO_RESOURCES_URI + cssClass.split(" ")[0] + ICON_FILE_EXTENSION;
    }

    private static String getThumbnailUrl(Node node, String repository, String workspace) {
        try {
            LinkManager linkManager = (LinkManager)CommonsUtils.getService(LinkManager.class);
            String mimeType = Utils.getMimeType(linkManager.isLink((Item)node) ? linkManager.getTarget(node, true) : node);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
            String portalName = containerInfo.getContainerName();
            String restContextName = org.exoplatform.ecm.webui.utils.Utils.getRestContextName((String)portalName);
            String preferenceWS = node.getSession().getWorkspace().getName();
            String encodedPath = URLEncoder.encode(node.getPath(), "utf-8");
            encodedPath = encodedPath.replaceAll("%2F", "/");
            if (mimeType.startsWith("image")) {
                return CommonsUtils.getCurrentDomain() + "/" + portalName + "/" + restContextName + "/thumbnailImage/custom/300x300/" + repository + "/" + preferenceWS + encodedPath;
            }
            if (mimeType.indexOf("icon") >= 0) {
                return Utils.getWebdavURL(node, repository, workspace);
            }
            if (org.exoplatform.services.cms.impl.Utils.isSupportThumbnailView((String)mimeType)) {
                return CommonsUtils.getCurrentDomain() + "/" + portalName + "/" + restContextName + "/thumbnailImage/big/" + repository + "/" + preferenceWS + encodedPath;
            }
            return null;
        }
        catch (Exception e) {
            LOG.debug((Object)"Cannot get thumbnail url");
            return "";
        }
    }

    private static String getWebdavURL(Node contentNode, String repository, String workspace) throws Exception {
        FriendlyService friendlyService = (FriendlyService)CommonsUtils.getService(FriendlyService.class);
        Object link = "#";
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        if (contentNode.isNodeType("nt:frozenNode")) {
            String uuid = contentNode.getProperty("jcr:frozenUuid").getString();
            Node originalNode = contentNode.getSession().getNodeByUUID(uuid);
            link = CommonsUtils.getCurrentDomain() + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + originalNode.getPath() + "?version=" + contentNode.getParent().getName();
        } else {
            link = CommonsUtils.getCurrentDomain() + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + contentNode.getPath();
        }
        return friendlyService.getFriendlyUri((String)link);
    }

    public static void postActivity(Node node, String activityMsgBundleKey) throws Exception {
        Utils.postActivity(node, activityMsgBundleKey, false, false, null, null);
    }

    public static ExoSocialActivity createShareActivity(Node node, String activityMsgBundleKey, String activityType, String comments, String perm) throws Exception {
        Utils.setActivityType(activityType);
        if (SHARE_FILE.equals(activityType)) {
            return Utils.postFileActivity(node, activityMsgBundleKey, false, false, comments, perm);
        }
        if (SHARE_CONTENT.equals(activityType)) {
            return Utils.postActivity(node, activityMsgBundleKey, false, false, comments, perm);
        }
        Utils.setActivityType(null);
        return Utils.postFileActivity(node, activityMsgBundleKey, false, false, comments, perm);
    }

    public static void postFileActivity(Node node, String activityMsgBundleKey) throws Exception {
        Utils.postFileActivity(node, activityMsgBundleKey, false, false, null, null);
    }

    public static ExoSocialActivity postActivity(Node node, String activityMsgBundleKey, boolean needUpdate, boolean isSystemComment, String systemComment, String perm) throws Exception {
        String commentID;
        String nodeActivityID;
        Object isSkipRaiseAct = DocumentContext.getCurrent().getAttributes().get("isSkipRaiseActivity");
        if (isSkipRaiseAct != null && Boolean.valueOf(isSkipRaiseAct.toString()).booleanValue()) {
            return null;
        }
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        String string = activityType = StringUtils.isNotEmpty((String)activityType) ? activityType : CONTENT_SPACES;
        if (!activityManager.isActivityTypeEnabled(activityType)) {
            return null;
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        ActivityCommonService activityCommonService = (ActivityCommonService)CommonsUtils.getService(ActivityCommonService.class);
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Utils.refineNode(node);
        String activityOwnerId = Utils.getActivityOwnerId(node);
        ExoSocialActivity exa = null;
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            try {
                nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
                exa = activityManager.getActivity(nodeActivityID);
            }
            catch (Exception e) {
                LOG.info((Object)"No activity is deleted, return no related activity");
            }
        }
        ExoSocialActivity activity = null;
        boolean commentFlag = false;
        if (node.isNodeType(MIX_COMMENT) && node.hasProperty(MIX_COMMENT_ID) && activityCommonService.isEditing(node)) {
            commentID = node.getProperty(MIX_COMMENT_ID).getString();
            if (StringUtils.isNotBlank((String)commentID)) {
                activity = activityManager.getActivity(commentID);
            }
            boolean bl = commentFlag = activity != null;
        }
        if (activity == null) {
            activity = Utils.createActivity(identityManager, activityOwnerId, node, activityMsgBundleKey, activityType, isSystemComment, systemComment, perm);
            Utils.setActivityType(null);
        }
        if (exa != null) {
            if (commentFlag) {
                Map paramsMap = activity.getTemplateParams();
                Object paramMessage = (String)paramsMap.get("MESSAGE");
                Object paramContent = (String)paramsMap.get("systemComment");
                if (!StringUtils.isEmpty((String)paramMessage)) {
                    paramMessage = (String)paramMessage + ActivityCommonService.VALUE_SEPERATOR + activityMsgBundleKey;
                    paramContent = StringUtils.isEmpty((String)systemComment) ? (String)paramContent + ActivityCommonService.VALUE_SEPERATOR + " " : (String)paramContent + ActivityCommonService.VALUE_SEPERATOR + systemComment;
                } else {
                    paramMessage = activityMsgBundleKey;
                    paramContent = systemComment;
                }
                paramsMap.put("MESSAGE", paramMessage);
                paramsMap.put("systemComment", paramContent);
                activity.setTemplateParams(paramsMap);
                Utils.updateNotifyMessages(activity, activityMsgBundleKey, systemComment);
                activityManager.updateActivity(activity);
            } else {
                Utils.updateNotifyMessages(activity, (String)activity.getTemplateParams().get("MESSAGE"), (String)activity.getTemplateParams().get("systemComment"));
                activityManager.saveComment(exa, activity);
                if (activityCommonService.isEditing(node)) {
                    commentID = activity.getId();
                    if (node.canAddMixin(MIX_COMMENT)) {
                        node.addMixin(MIX_COMMENT);
                    }
                    if (node.isNodeType(MIX_COMMENT)) {
                        node.setProperty(MIX_COMMENT_ID, commentID);
                    }
                }
            }
            if (needUpdate) {
                Utils.updateMainActivity(activityManager, node, exa);
            }
            return activity;
        }
        String spaceGroupName = Utils.getSpaceName(node);
        Space space = spaceService.getSpaceByGroupId("/spaces/" + spaceGroupName);
        if (spaceGroupName != null && spaceGroupName.length() > 0 && space != null) {
            Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getPrettyName());
            activityManager.saveActivityNoReturn(spaceIdentity, activity);
        } else if (activityOwnerId != null && activityOwnerId.length() > 0) {
            Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", activityOwnerId);
            activityManager.saveActivityNoReturn(ownerIdentity, activity);
        } else {
            return null;
        }
        if (!StringUtils.isEmpty((String)activity.getId())) {
            ActivityTypeUtils.attachActivityId((Node)node, (String)activity.getId());
        }
        Utils.updateMainActivity(activityManager, node, activity);
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            try {
                nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
                exa = activityManager.getActivity(nodeActivityID);
            }
            catch (Exception e) {
                LOG.info((Object)"No activity is deleted, return no related activity");
            }
            if (exa != null && !commentFlag && isSystemComment) {
                activityManager.saveComment(exa, activity);
                if (activityCommonService.isEditing(node)) {
                    commentID = activity.getId();
                    if (node.canAddMixin(MIX_COMMENT)) {
                        node.addMixin(MIX_COMMENT);
                    }
                    if (node.isNodeType(MIX_COMMENT)) {
                        node.setProperty(MIX_COMMENT_ID, commentID);
                    }
                }
            }
        }
        return activity;
    }

    public static ExoSocialActivity postFileActivity(Node node, String activityMsgBundleKey, boolean needUpdate, boolean isComment, String systemComment, String perm) throws Exception {
        String commentID;
        String nodeActivityID;
        Object isSkipRaiseAct = DocumentContext.getCurrent().getAttributes().get("isSkipRaiseActivity");
        if (isSkipRaiseAct != null && Boolean.valueOf(isSkipRaiseAct.toString()).booleanValue()) {
            return null;
        }
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        String string = activityType = StringUtils.isNotEmpty((String)activityType) ? activityType : FILE_SPACES;
        if (!activityManager.isActivityTypeEnabled(activityType)) {
            return null;
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        ActivityCommonService activityCommonService = (ActivityCommonService)CommonsUtils.getService(ActivityCommonService.class);
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Utils.refineNode(node);
        String activityOwnerId = Utils.getActivityOwnerId(node);
        ExoSocialActivity exa = null;
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            try {
                nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
                exa = activityManager.getActivity(nodeActivityID);
            }
            catch (Exception e) {
                LOG.info((Object)"No activity is deleted, return no related activity");
            }
        }
        ExoSocialActivity activity = null;
        boolean commentFlag = false;
        if (node.isNodeType(MIX_COMMENT) && activityCommonService.isEditing(node) && node.hasProperty(MIX_COMMENT_ID)) {
            commentID = node.getProperty(MIX_COMMENT_ID).getString();
            if (StringUtils.isNotBlank((String)commentID)) {
                activity = activityManager.getActivity(commentID);
            }
            boolean bl = commentFlag = activity != null;
        }
        if (activity == null) {
            activity = Utils.createActivity(identityManager, activityOwnerId, node, activityMsgBundleKey, activityType, isComment, systemComment, perm);
            Utils.setActivityType(null);
        }
        if (exa != null) {
            if (commentFlag) {
                Map paramsMap = activity.getTemplateParams();
                Object paramMessage = (String)paramsMap.get("MESSAGE");
                Object paramContent = (String)paramsMap.get("systemComment");
                if (!StringUtils.isEmpty((String)paramMessage)) {
                    paramMessage = (String)paramMessage + ActivityCommonService.VALUE_SEPERATOR + activityMsgBundleKey;
                    paramContent = StringUtils.isEmpty((String)systemComment) ? (String)paramContent + ActivityCommonService.VALUE_SEPERATOR + " " : (String)paramContent + ActivityCommonService.VALUE_SEPERATOR + systemComment;
                } else {
                    paramMessage = activityMsgBundleKey;
                    paramContent = systemComment;
                }
                paramsMap.put("MESSAGE", paramMessage);
                paramsMap.put("systemComment", paramContent);
                activity.setTemplateParams(paramsMap);
                Utils.updateNotifyMessages(activity, activityMsgBundleKey, systemComment);
                activityManager.updateActivity(activity);
            } else {
                Utils.updateNotifyMessages(activity, (String)activity.getTemplateParams().get("MESSAGE"), (String)activity.getTemplateParams().get("systemComment"));
                activityManager.saveComment(exa, activity);
                if (activityCommonService.isEditing(node)) {
                    commentID = activity.getId();
                    if (node.canAddMixin(MIX_COMMENT)) {
                        node.addMixin(MIX_COMMENT);
                    }
                    if (node.isNodeType(MIX_COMMENT)) {
                        node.setProperty(MIX_COMMENT_ID, commentID);
                    }
                }
            }
            return activity;
        }
        String spaceGroupName = Utils.getSpaceName(node);
        Space space = spaceService.getSpaceByGroupId("/spaces/" + spaceGroupName);
        if (spaceGroupName != null && spaceGroupName.length() > 0 && space != null) {
            Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getPrettyName());
            activityManager.saveActivityNoReturn(spaceIdentity, activity);
        } else if (activityOwnerId != null && activityOwnerId.length() > 0) {
            if (!Utils.isPublic(node)) {
                return null;
            }
            Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", activityOwnerId);
            activityManager.saveActivityNoReturn(ownerIdentity, activity);
        } else {
            return null;
        }
        if (!StringUtils.isEmpty((String)activity.getId())) {
            ActivityTypeUtils.attachActivityId((Node)node, (String)activity.getId());
        }
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            try {
                nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
                exa = activityManager.getActivity(nodeActivityID);
            }
            catch (Exception e) {
                LOG.info((Object)"No activity is deleted, return no related activity");
            }
            if (exa != null && !commentFlag && isComment) {
                activity.setId(null);
                Utils.updateNotifyMessages(activity, (String)activity.getTemplateParams().get("MESSAGE"), (String)activity.getTemplateParams().get("systemComment"));
                activityManager.saveComment(exa, activity);
                if (activityCommonService.isEditing(node)) {
                    commentID = activity.getId();
                    if (node.canAddMixin(MIX_COMMENT)) {
                        node.addMixin(MIX_COMMENT);
                    }
                    if (node.isNodeType(MIX_COMMENT)) {
                        node.setProperty(MIX_COMMENT_ID, commentID);
                    }
                }
            }
        }
        return activity;
    }

    public static void updateNotifyMessages(ExoSocialActivity activity, String activityMsgBundleKey, String systemComment) throws Exception {
        Locale locale = new Locale("en");
        ResourceBundleService resourceBundleService = (ResourceBundleService)CommonsUtils.getService(ResourceBundleService.class);
        ResourceBundle res = resourceBundleService.getResourceBundle("locale.extension.SocialIntegration", locale);
        StringBuffer sb = new StringBuffer();
        String[] keys = activityMsgBundleKey.split(ActivityCommonService.VALUE_SEPERATOR);
        String[] values = systemComment.split(ActivityCommonService.VALUE_SEPERATOR);
        for (String key : keys) {
            String message;
            try {
                message = res.getString(key);
            }
            catch (MissingResourceException mre) {
                message = key;
            }
            if (values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    message = message.replace("{" + i + "}", values[i]);
                }
            }
            sb.append(message).append("\n");
        }
        activity.setTitle(sb.toString());
    }

    private static void updateMainActivity(ActivityManager activityManager, Node contentNode, ExoSocialActivity activity) {
        String state;
        String nodeTitle;
        String documentTypeLabel;
        Map activityParams = activity.getTemplateParams();
        String nodeType = null;
        String currentVersion = null;
        TemplateService templateService = (TemplateService)CommonsUtils.getService(TemplateService.class);
        try {
            nodeType = contentNode.getPrimaryNodeType().getName();
            documentTypeLabel = templateService.getTemplateLabel(nodeType);
        }
        catch (Exception e) {
            documentTypeLabel = "";
        }
        try {
            nodeTitle = org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)contentNode);
        }
        catch (Exception e1) {
            nodeTitle = "";
        }
        try {
            state = contentNode.hasProperty(CURRENT_STATE_PROP) ? contentNode.getProperty(CURRENT_STATE_PROP).getValue().getString() : "";
        }
        catch (Exception e) {
            state = "";
        }
        try {
            currentVersion = contentNode.getBaseVersion().getName();
            if (currentVersion.contains("jcr:rootVersion")) {
                currentVersion = "0";
            }
        }
        catch (Exception e) {
            currentVersion = "";
        }
        activityParams.put("state", state);
        activityParams.put("docTypeLabel", documentTypeLabel);
        activityParams.put("docTitle", nodeTitle);
        activityParams.put("docVersion", currentVersion);
        String summary = Utils.getSummary(contentNode);
        summary = Utils.getFirstSummaryLines(summary, MAX_SUMMARY_LINES_COUNT);
        activityParams.put("docSummary", summary);
        activity.setTemplateParams(activityParams);
        activityManager.updateActivity(activity);
    }

    private static boolean isSupportedContent(Node node) throws Exception {
        if (Utils.getActivityOwnerId(node) != null && Utils.getActivityOwnerId(node).length() > 0) {
            Node userNode;
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            if (sessionProvider == null) {
                sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            }
            if ((userNode = nodeHierarchyCreator.getUserNode(sessionProvider, Utils.getActivityOwnerId(node))) != null && node.getPath().startsWith(userNode.getPath() + "/Private/")) {
                return false;
            }
        }
        return true;
    }

    private static void refineNode(Node currentNode) throws Exception {
        ExoContainer container;
        LinkManager linkManager;
        if (currentNode instanceof NodeImpl && !((NodeImpl)currentNode).isValid() && (linkManager = (LinkManager)(container = ExoContainerContext.getCurrentContainer()).getComponentInstanceOfType(LinkManager.class)).isLink((Item)currentNode)) {
            try {
                currentNode = linkManager.getTarget(currentNode, false);
            }
            catch (RepositoryException ex) {
                currentNode = linkManager.getTarget(currentNode, true);
            }
        }
    }

    public static String getActivityOwnerId(Node node) {
        String activityOwnerId = "";
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            activityOwnerId = conversationState.getIdentity().getUserId();
        } else {
            try {
                activityOwnerId = node.getProperty("publication:lastUser").getString();
            }
            catch (Exception e) {
                LOG.info((Object)"No lastUser publication");
            }
        }
        return activityOwnerId;
    }

    public static String getSpaceName(Node node) throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)CommonsUtils.getService(NodeHierarchyCreator.class);
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        String spacesFolder = groupPath + "/spaces/";
        String spaceName = "";
        String nodePath = node.getPath();
        if (nodePath.startsWith(spacesFolder)) {
            spaceName = nodePath.substring(spacesFolder.length());
            spaceName = spaceName.substring(0, spaceName.indexOf("/"));
        }
        return spaceName;
    }

    public static boolean isPublic(Node node) {
        if (node instanceof ExtendedNode) {
            ExtendedNode n = (ExtendedNode)node;
            try {
                List permissions = n.getACL().getPermissions("any");
                if (permissions != null && permissions.size() > 0) {
                    for (String p : permissions) {
                        if (!"read".equalsIgnoreCase(p)) continue;
                        return true;
                    }
                }
            }
            catch (RepositoryException ex) {
                return false;
            }
        }
        return false;
    }

    public static String getContentLink(Node node) throws Exception {
        DocumentService documentService = (DocumentService)CommonsUtils.getService(DocumentService.class);
        return documentService.getShortLinkInDocumentsApp(node.getSession().getWorkspace().getName(), ((NodeImpl)node).getInternalIdentifier());
    }

    public static ExoSocialActivity createActivity(IdentityManager identityManager, String activityOwnerId, Node node, String activityMsgBundleKey, String activityType) throws Exception {
        return Utils.createActivity(identityManager, activityOwnerId, node, activityMsgBundleKey, activityType, false, null, null);
    }

    public static ExoSocialActivity createActivity(IdentityManager identityManager, String activityOwnerId, Node node, String activityMsgBundleKey, String activityType, boolean isSystemComment, String systemComment, String perm) throws Exception {
        Map<String, String> activityParams = Utils.populateActivityData(node, activityOwnerId, activityMsgBundleKey, isSystemComment, systemComment, perm);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        String userId = "";
        userId = ConversationState.getCurrent() != null ? ConversationState.getCurrent().getIdentity().getUserId() : activityOwnerId;
        Identity identity = identityManager.getOrCreateIdentity("organization", userId, false);
        activity.setUserId(identity.getId());
        activity.setType(activityType);
        activity.setUrl(node.getPath());
        if (StringUtils.isNotEmpty((String)activityMsgBundleKey) && StringUtils.isNotEmpty((String)systemComment)) {
            Utils.updateNotifyMessages((ExoSocialActivity)activity, activityMsgBundleKey, systemComment);
        } else if (StringUtils.isNotEmpty((String)systemComment)) {
            activity.setTitle(systemComment);
        } else {
            activity.setTitle("");
        }
        activity.setTemplateParams(activityParams);
        return activity;
    }

    public static void deleteFileActivity(Node node) throws RepositoryException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ActivityManager activityManager = (ActivityManager)container.getComponentInstanceOfType(ActivityManager.class);
        String nodeActivityID = "";
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            try {
                nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
                if (activityManager.getActivity(nodeActivityID) != null) {
                    activityManager.deleteActivity(nodeActivityID);
                }
            }
            catch (Exception e) {
                LOG.info((Object)"No activity is deleted, return no related activity");
            }
        }
    }

    public static String getIllustrativeImage(Node node) {
        WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)CommonsUtils.getService(WebSchemaConfigService.class);
        WebContentSchemaHandler contentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        Node illustrativeImage = null;
        String uri = "";
        try {
            illustrativeImage = contentSchemaHandler.getIllustrationImage(node);
            uri = Utils.generateThumbnailImageURI(illustrativeImage);
        }
        catch (PathNotFoundException ex) {
            return uri;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return uri;
    }

    public static String generateThumbnailImageURI(Node file) throws Exception {
        StringBuilder builder = new StringBuilder();
        NodeLocation fielLocation = NodeLocation.getNodeLocationByNode((Node)file);
        String repository = fielLocation.getRepository();
        String workspaceName = fielLocation.getWorkspace();
        String nodeIdentifiler = file.getPath().replaceFirst("/", "");
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        InputStream stream = file.getNode("jcr:content").getProperty("jcr:data").getStream();
        if (stream.available() == 0) {
            return null;
        }
        stream.close();
        builder.append("/").append(portalName).append("/").append(restContextName).append("/").append("thumbnailImage/medium/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler);
        return builder.toString();
    }

    public static String getMimeType(Node node) {
        try {
            if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
                return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static String getSummary(Node node) {
        String desc;
        block6: {
            desc = "";
            try {
                if (node != null) {
                    Node content;
                    if (node.hasProperty("exo:summary")) {
                        desc = node.getProperty("exo:summary").getValue().getString();
                    } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:description") && content.getProperty("dc:description").getValues().length > 0) {
                        desc = content.getProperty("dc:description").getValues()[0].getString();
                    }
                }
            }
            catch (RepositoryException re) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)"RepositoryException: ", (Throwable)re);
            }
        }
        return desc;
    }

    public static String getFirstSummaryLines(String source) {
        return Utils.getFirstSummaryLines(source, MAX_SUMMARY_LINES_COUNT);
    }

    private static String convertActivityContent(String source) {
        String result = source;
        result = result.replaceAll("(?i)<head>.*</head>", "");
        result = result.replaceAll("(?i)<script.*>.*</script>", "");
        result = result.replaceAll("(?i)<style.*>.*</style>", "");
        result = result.replaceAll("<([a-zA-Z\"]+) *[^/]*?>", "");
        result = result.replaceAll("</p>", "<br>");
        result = result.replaceAll("</([a-zA-Z]+) *[^/]*?>", "");
        result = result.replaceAll("([\r\n\t])+", "");
        result = result.replaceAll("^(<br>)", "");
        result = result.replaceAll("(<br>[ \r\t\n]+<br>)", "\n");
        result = result.replaceAll("(<br>)+", "\n");
        return result;
    }

    public static String getFirstSummaryLines(String source, int linesCount) {
        Object result = Utils.convertActivityContent(source);
        int i = 0;
        int index = -1;
        while ((index = ((String)result).indexOf("\n", index + 1)) >= 0 && ++i < linesCount) {
        }
        if (index < 0) {
            if (((String)result).length() > MAX_SUMMARY_CHAR_COUNT) {
                return ((String)result).substring(0, MAX_SUMMARY_CHAR_COUNT - 1) + "...";
            }
            return result;
        }
        if (index > MAX_SUMMARY_CHAR_COUNT) {
            index = MAX_SUMMARY_CHAR_COUNT - 1;
        }
        result = ((String)result).substring(0, index) + "\n...";
        return result;
    }

    public static String[] getSystemCommentTitle(Map<String, String> activityParams) {
        if (activityParams == null) {
            return null;
        }
        String commentValue = activityParams.get("systemComment");
        if (!StringUtils.isEmpty((String)commentValue)) {
            if (commentValue.indexOf(ActivityCommonService.VALUE_SEPERATOR) >= 0) {
                String[] result = commentValue.split(ActivityCommonService.VALUE_SEPERATOR);
                return result;
            }
            return new String[]{commentValue};
        }
        return null;
    }

    public static String[] getSystemCommentBundle(Map<String, String> activityParams) {
        if (activityParams == null) {
            return null;
        }
        String tmp = activityParams.get("isSystemComment");
        if (tmp == null) {
            return null;
        }
        try {
            String commentMessage;
            if (Boolean.parseBoolean(tmp) && !StringUtils.isEmpty((String)(commentMessage = activityParams.get("MESSAGE")))) {
                if (commentMessage.indexOf(ActivityCommonService.VALUE_SEPERATOR) >= 0) {
                    String[] result = commentMessage.split(ActivityCommonService.VALUE_SEPERATOR);
                    return result;
                }
                return new String[]{commentMessage};
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String getBundleValue(String key) {
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            String value = res.getString(key);
            return value;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String processMentions(String comment) {
        String[] excerpts = ((String)comment).split("@");
        comment = excerpts[0];
        String mentioned = "";
        for (int i = 1; i < excerpts.length; ++i) {
            String name = excerpts[i].split(" ")[0];
            Identity identity = org.exoplatform.social.notification.Utils.getIdentityManager().getOrCreateIdentity("organization", name, true);
            if (identity != null) {
                mentioned = Utils.addMentioned(name, identity.getProfile().getFullName());
            }
            if (mentioned.isEmpty()) {
                if (excerpts[i].isEmpty()) {
                    comment = (String)comment + " ";
                    continue;
                }
                comment = (String)comment + excerpts[i] + " ";
                continue;
            }
            comment = (String)comment + mentioned + excerpts[i].substring(name.length(), excerpts[i].length());
            mentioned = "";
        }
        return comment;
    }

    private static String addMentioned(String mention, String fullname) {
        String profileURL = CommonsUtils.getCurrentDomain() + LinkProvider.getProfileUri((String)mention);
        return "<a href=" + profileURL + " type=\"mentionedUser\" rel=\"nofollow\">" + fullname + "</a>";
    }

    public static void setAvatarUrl(Node commentNode) throws RepositoryException {
        String name = commentNode.getProperty("exo:commentor").getString();
        Identity identity = org.exoplatform.social.notification.Utils.getIdentityManager().getOrCreateIdentity("organization", name, true);
        Profile profile = identity.getProfile();
        if (profile.getAvatarUrl() != null) {
            commentNode.setProperty("exo:commentorAvatar", profile.getAvatarUrl());
        } else {
            commentNode.setProperty("exo:commentorAvatar", DEFAULT_AVATAR);
        }
    }

    public static String addVersionComment(Node node, String commentText, String userId) throws Exception {
        String nodeActivityID = null;
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        String activityOwnerId = Utils.getActivityOwnerId(node);
        boolean deletedActivity = false;
        if (node.hasProperty(ActivityTypeUtils.EXO_ACTIVITY_ID)) {
            nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
            deletedActivity = activityManager.getActivity(nodeActivityID) == null;
        }
        ExoSocialActivity activity = Utils.createActivity(identityManager, activityOwnerId, node, commentText, activityType, true, "", "");
        Utils.setActivityType(null);
        if (!node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO) || deletedActivity) {
            String spaceGroupName = Utils.getSpaceName(node);
            Space space = spaceService.getSpaceByGroupId("/spaces/" + spaceGroupName);
            if (spaceGroupName != null && !spaceGroupName.isEmpty() && space != null) {
                Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getPrettyName());
                activityManager.saveActivityNoReturn(spaceIdentity, activity);
            } else if (activityOwnerId != null && !activityOwnerId.isEmpty()) {
                if (!Utils.isPublic(node)) {
                    return null;
                }
                Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", activityOwnerId);
                activityManager.saveActivityNoReturn(ownerIdentity, activity);
            } else {
                return null;
            }
            if (!StringUtils.isEmpty((String)activity.getId())) {
                nodeActivityID = activity.getId();
                ActivityTypeUtils.attachActivityId((Node)node, (String)activity.getId());
            }
        }
        if (nodeActivityID != null && !nodeActivityID.isEmpty() && commentText != null && !commentText.trim().isEmpty()) {
            Identity identity = identityManager.getOrCreateIdentity("organization", userId);
            activity = activityManager.getActivity(nodeActivityID);
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl(identity.getId(), "exosocial:spaces", commentText, null);
            activityManager.saveComment(activity, (ExoSocialActivity)comment);
            return comment.getId();
        }
        LOG.warn("Cannot add comment. ActivityId and comment shouldn't be null or empty. activityId: {}, comment: {}", new Object[]{nodeActivityID, commentText});
        return null;
    }
}

