/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

public class FeatureNaming<E> {
    private final Map<String, List<String>> aliases = new HashMap<String, List<String>>();
    private final Map<String, E> values = new HashMap<String, E>();

    private static CharSequence name(DataStore dataStore) {
        String string;
        if (dataStore != null && (string = dataStore.getDisplayName()) != null) {
            return string;
        }
        return Vocabulary.formatInternational((short)208);
    }

    private static Locale locale(DataStore dataStore) {
        return dataStore != null ? dataStore.getLocale() : null;
    }

    public E get(DataStore dataStore, String string) throws IllegalNameException {
        Object[] objectArray;
        short s;
        E e = this.values.get(string);
        if (e != null) {
            return e;
        }
        List<String> list = this.aliases.get(string);
        if (list == null) {
            s = 17;
            objectArray = new CharSequence[]{FeatureNaming.name(dataStore), string};
        } else if (list.size() >= 2) {
            s = 15;
            objectArray = new CharSequence[]{FeatureNaming.name(dataStore), list.get(0), list.get(1), string};
        } else {
            return null;
        }
        throw new IllegalNameException(FeatureNaming.locale(dataStore), s, objectArray);
    }

    public void add(DataStore dataStore, GenericName genericName, E e) throws IllegalNameException {
        Object object;
        ArgumentChecks.ensureNonNull((String)"name", (Object)genericName);
        ArgumentChecks.ensureNonNull((String)"value", e);
        String string = genericName.toString();
        E e2 = this.values.put(string, e);
        if (e2 != null) {
            object = this.aliases.get(string);
            if (object == null || object.contains(string)) {
                if (this.values.put(string, e2) != e) {
                    throw new ConcurrentModificationException(FeatureNaming.name(dataStore).toString());
                }
                throw new IllegalNameException(FeatureNaming.locale(dataStore), 16, FeatureNaming.name(dataStore), string);
            }
            CollectionsExt.addToMultiValuesMap(this.aliases, (Object)string, (Object)string);
        }
        while (genericName instanceof ScopedName) {
            object = (genericName = ((ScopedName)genericName).tail()).toString();
            List list = CollectionsExt.addToMultiValuesMap(this.aliases, (Object)object, (Object)string);
            if (list.size() > 1) {
                if (list.contains(object)) continue;
                this.values.remove(object);
                continue;
            }
            if (this.values.putIfAbsent((String)object, e) == null) continue;
            assert (!list.contains(object)) : object;
            CollectionsExt.addToMultiValuesMap(this.aliases, (Object)object, (Object)object);
        }
    }

    public boolean remove(DataStore dataStore, GenericName genericName) throws IllegalNameException {
        ArgumentChecks.ensureNonNull((String)"name", (Object)genericName);
        String string = genericName.toString();
        if (this.values.remove(string) == null) {
            return false;
        }
        List list = CollectionsExt.removeFromMultiValuesMap(this.aliases, (Object)string, (Object)string);
        if (list != null && list.size() == 1) {
            String string2 = (String)list.get(0);
            assert (!string2.equals(string)) : string2;
            if (this.values.put(string, this.values.get(string2)) != null) {
                throw new ConcurrentModificationException(FeatureNaming.name(dataStore).toString());
            }
        }
        boolean bl = false;
        while (genericName instanceof ScopedName) {
            String string3 = (genericName = ((ScopedName)genericName).tail()).toString();
            list = CollectionsExt.removeFromMultiValuesMap(this.aliases, (Object)string3, (Object)string);
            bl |= list == null;
            if (list == null || list.isEmpty()) {
                bl |= this.values.remove(string3) == null;
                continue;
            }
            if (list.size() != 1) continue;
            String string4 = (String)list.get(0);
            assert (!string4.equals(string)) : string4;
            bl |= this.values.putIfAbsent(string3, this.values.get(string4)) != null;
        }
        if (bl) {
            throw new IllegalNameException(FeatureNaming.locale(dataStore), 10, FeatureNaming.name(dataStore), string);
        }
        return true;
    }
}

