/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.activities;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TemplateParamsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(TemplateParamsUpgradePlugin.class);
    private final PortalContainer container;
    private final EntityManagerService entityManagerService;
    private static final String OLD_TEMPLATE_PARAMS_KEY = "old.template.params.key";
    private static final String NEW_TEMPLATE_PARAMS_KEY = "new.template.params.key";
    private int templatePramasUpdatedCount;
    private String oldTemplateParamskey;
    private String newTemplateParamskey;

    public TemplateParamsUpgradePlugin(PortalContainer container, EntityManagerService entityManagerService, InitParams initParams) {
        super(initParams);
        this.container = container;
        this.entityManagerService = entityManagerService;
        if (initParams.containsKey((Object)OLD_TEMPLATE_PARAMS_KEY)) {
            this.oldTemplateParamskey = initParams.getValueParam(OLD_TEMPLATE_PARAMS_KEY).getValue();
        }
        if (initParams.containsKey((Object)NEW_TEMPLATE_PARAMS_KEY)) {
            this.newTemplateParamskey = initParams.getValueParam(NEW_TEMPLATE_PARAMS_KEY).getValue();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (StringUtils.isEmpty((CharSequence)this.oldTemplateParamskey) || StringUtils.isEmpty((CharSequence)this.newTemplateParamskey)) {
            LOG.error((Object)"Couldn't process upgrade, all parameters are mandatory");
            return;
        }
        long startupTime = System.currentTimeMillis();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        boolean transactionStarted = false;
        LOG.info("Start upgrade of ACTIVITY_TEMPLATE_PARAMS with key {} to use {}", new Object[]{this.oldTemplateParamskey, this.newTemplateParamskey});
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        try {
            if (!entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().begin();
                transactionStarted = true;
            }
            String sqlString = "UPDATE SOC_ACTIVITY_TEMPLATE_PARAMS SET TEMPLATE_PARAM_KEY = TRIM(:newTemplateParamskey) WHERE TEMPLATE_PARAM_KEY LIKE :oldTemplateParamskey";
            Query nativeQuery = entityManager.createNativeQuery(sqlString);
            nativeQuery.setParameter("newTemplateParamskey", (Object)this.newTemplateParamskey);
            nativeQuery.setParameter("oldTemplateParamskey", (Object)this.oldTemplateParamskey);
            this.templatePramasUpdatedCount = nativeQuery.executeUpdate();
            LOG.info("End upgrade of '{}' ACTIVITY_TEMPLATE_PARAMS with key {} to use {}. It took {} ms", new Object[]{this.templatePramasUpdatedCount, this.oldTemplateParamskey, this.newTemplateParamskey, System.currentTimeMillis() - startupTime});
            if (transactionStarted && entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().commit();
                entityManager.clear();
                entityManager.flush();
            }
        }
        catch (Exception e) {
            if (transactionStarted && entityManager.getTransaction().isActive() && entityManager.getTransaction().getRollbackOnly()) {
                entityManager.getTransaction().rollback();
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public int getTemplatePramasUpdatedCount() {
        return this.templatePramasUpdatedCount;
    }
}

